<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\add_to_cart;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class ProductController extends Controller
{
    public function index_add()
    {
        $Products = Product::all();
        return view('admin/product', compact('Products'));
    }
    
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = Product::where(['id' => $id])->get();

            $result['category_id']=$arr['0']->category_id;
            $result['name']=$arr['0']->name;
            $result['image']=$arr['0']->image;
            $result['slug']=$arr['0']->slug;
            $result['product_price']=$arr['0']->product_price;
            $result['short_desc']=$arr['0']->short_desc;
            $result['desc']=$arr['0']->desc;
            $result['status']=$arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['category_id']='';
            $result['name']='';
            $result['slug']='';
            $result['image']='';
            $result['product_price']='';
            $result['short_desc']='';
            $result['desc']='';
            $result['status']='';
            $result['id']=0;
        }
        
        $result['category']=DB::table('categories')->where(['status'=>1])->get();
        return view('admin/product-add',$result);
    }

    public function create(Request $request)
    {
        if($request->post('id')>0){
            $image_validation="mimes:jpeg,jpg,png";
        }else{
            $image_validation="required|mimes:jpeg,jpg,png";
        }

        $validatedData = $request->validate([
            'name'=>'required',
            'image'=> $image_validation,
            'slug'=>'required|unique:products,slug,'.$request->post('id'), 

        ]);
        if($request->input('id')>0){
            $Products=Product::find($request->input('id'));
            $msg="Product updated";
        }else{
            $Products = new Product;
            $msg="Product inserted";
        }

        if($request->hasfile('image')){
            if($request->post('id')>0){                
                $arrImage=DB::table('products')->where(['id'=>$request->post('id')])->get();
                if(Storage::exists('/public/media/'.$arrImage[0]->image)){
                    Storage::delete('/public/media/'.$arrImage[0]->image);
                }
            }
            $image=$request->file('image');
            $ext=$image->extension();
            $image_name=time().'.'.$ext;
            $image->storeAs('/public/media/',$image_name);
            $Products->image=$image_name;
        }


        $Products->category_id= $request->post('category_id');
        $Products->name=$request->post('name');
        $Products->slug=$request->post('slug');
        $Products->product_price=$request->post('product_price');
        $Products->short_desc=$request->post('short_desc');
        $Products->desc=$request->post('desc');
        $Products->status=1;
        $Products->save();
        Session::flash('message', $msg);
        return redirect('admin/product');
    }


    public function status(Request $request,$status,$id){
        $model=Product::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Product status updated');
        return redirect('admin/product');
    }

    public function show(Product $Product)
    {
    }

    public function edit(Product $Product)
    {
    }


    public function delete(Request $request, $id)
    {
        $model = Product::find($id);
        $model->delete();
        Session::flash('message', 'Product deleted');
        return redirect('admin/product');
    }

    public function menu(Request $request)
    {
    //     $result['home_categories'] = DB::table('categories')
    //     ->where(['status' => 1])
    //     ->get();

    // $result['product'] =
    //     DB::table('products')
    //     ->where(['status' => 1])
    //     ->get();

    $category = Category::with('products')->get();

    // cart data 

    if ($request->session()->has('FRONT_USER_LOGIN')) {
        $uid = $request->session()->get('FRONT_USER_ID');
        $user_type = "Reg";
    } else {
        $uid = getUserTempId();
        $user_type = "Not-Reg";
    }
    $cartdatas = add_to_cart::query()->with('insert_topping')
        ->where(['user_id' => $uid])
        ->where(['user_type' => $user_type])
        ->where(['status' => null])
        ->get();

    $i = 0;
    foreach ($cartdatas as $cartdata) {
        if ($cartdata->category_id == 1) {


            $total_price = 0;
            $total_price = ($cartdata->product_price + $cartdata->ws_price + $cartdata->sauce_price + $cartdata->crust_price + $cartdata->dipping_price + $cartdata->cooking_price);
            foreach ($cartdata->insert_topping as $insert_topping) {
                if ($insert_topping->sum('status') <= 6) {
                    $total_price += $insert_topping->toppings_left_id = 0 + $insert_topping->toppings_center_id = 0 + $insert_topping->toppings_right_id = 0;
                } else {
                    $total_price += $insert_topping->toppings_left_id + $insert_topping->toppings_center_id + $insert_topping->toppings_right_id;
                }
            }
        } else {
            $total_price = 0;
            $total_price = ($cartdata->product_price + $cartdata->ws_price + $cartdata->sauce_price + $cartdata->crust_price + $cartdata->dipping_price + $cartdata->cooking_price);
            foreach ($cartdata->insert_topping as $insert_topping) {
                $total_price += $insert_topping->toppings_left_id + $insert_topping->toppings_center_id + $insert_topping->toppings_right_id;
            }
        }

        $cartdatas[$i]->total_price = $total_price * $cartdata->pqty;
        $i++;
    }

    return view('front.menu', compact('category') , compact('cartdatas') );
    }
}
