<?php

namespace App\Http\Controllers;

use App\Models\Size;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class SizeController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = Size::where(['id' => $id])->get();

            $result['size'] = $arr['0']->size;
            $result['category_id'] = $arr['0']->category_id;
            $result['price'] = $arr['0']->price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['size'] = '';
            $result['category_id'] = '';
            $result['price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $Sizes = Size::all();
        $result['category']=DB::table('categories')->where(['status'=>1])->get();
        return view('admin/size', compact('Sizes'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "size" => 'required|unique:Sizes,id,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $Sizes=Size::find($request->input('id'));
            $msg="Size updated";
        }else{
            $Sizes = new Size;
            $msg="Size inserted";
        }
        $Sizes->size = $request->input('size');
        $Sizes->category_id = $request->input('category_id');
        $Sizes->price = $request->input('price');
        $Sizes->status=1;
        $Sizes->save();
        Session::flash('message', $msg);
        return redirect('admin/size');
    }


    public function store(Request $request)
    {
    }

    public function show(Size $Size)
    {
    }

    public function edit(Size $Size)
    {
    }

    public function status(Request $request,$status,$id){
        $model=Size::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Size status updated');
        return redirect('admin/size');
    }

    public function delete(Request $request, $id)
    {
        $model = Size::find($id);
        $model->delete();
        Session::flash('message', 'Size deleted');
        return redirect('admin/size');
    }
}
