<?php

namespace App\Http\Controllers;

use App\Models\toppings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class ToppingsController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = toppings::where(['id' => $id])->get();

            $result['toppings'] = $arr['0']->toppings;
            $result['toppings_price'] = $arr['0']->toppings_price;
            $result['toppings_type'] = $arr['0']->toppings_type;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['toppings'] = '';
            $result['toppings_price'] = '';
            $result['toppings_type'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $topping = toppings::all();
        return view('admin/toppings', compact('topping'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "toppings" => 'required|unique:toppings,id,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $toppings=toppings::find($request->input('id'));
            $msg="toppings updated";
        }else{
            $toppings = new toppings;
            $msg="Toppings inserted";
        }
        $toppings->toppings = $request->input('toppings');
        $toppings->toppings_price = $request->input('toppings_price');
        $toppings->toppings_type = $request->input('toppings_type');
        $toppings->status=1;
        $toppings->save();
        Session::flash('message', $msg);
        return redirect('admin/toppings');
    }


    public function store(Request $request)
    {
    }

    public function show(toppings $toppings)
    {
    }

    public function edit(toppings $toppings)
    {
    }

    public function status(Request $request,$status,$id){
        $model=toppings::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Toppings status updated');
        return redirect('admin/toppings');
    }

    public function delete(Request $request, $id)
    {
        $model = toppings::find($id);
        $model->delete();
        Session::flash('message', 'Toppings deleted');
        return redirect('admin/toppings');
    }
}
