@extends('layout.pageheader')
@section('title', 'My Account')
@section('content')
<div class="mad-breadcrumb with-bg-image" data-bg-image-src="{{ asset('assets_front/images/header.webp') }}" style="background-image: url(&quot;assets_front/images/1920x392_bg1.jpg&quot;);">
        <div class="container">
          <h1 class="mad-page-title">My Account</h1>
          <nav class="mad-breadcrumb-path"><span><a href="{{url('/')}}">Home</a></span> / <span>My Account</span>
          </nav>
        </div>
      </div>
      <div class="mad-content no-pd">
        <div class="container">
          <div class="mad-section mad-section--stretched mad-colorizer--scheme-">
            <div class="mad-colorizer-bg-color" style="left: -55.6px; right: -55.6px;">
              <div class="with-svg-item"><img src="{{ asset('assets_front/images/mud4.png') }}" alt=""></div>
            </div>
            <div class="row hr-size-2 vr-size-2">
              <main id="main" class="col-xl-9">
                <div class="content-element-15">
                  <h3 class="mad-page-title">Order History</h3>
                  <div class="mad-table-wrap shop-cart-form">
                    <table class="mad-table--responsive-md">
                      <thead>
                        <tr class="bg">
                          <th class="order-number">Order #</th>
                          <th class="order-date">Date</th>
                          <th>Status</th>
                          <th>Total</th>
                          <th>Actions</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td data-cell-title="Order #">12345</td>
                          <td data-cell-title="Date">December 17, 2020</td>
                          <td data-cell-title="Status">Completed</td>
                          <td data-cell-title="Total"><span class="mad-product-price">14.99</span></td>
                          <td data-cell-title="Actions"><a href="#" class="mad-link color-2">View</a></td>
                        </tr>
                        <tr>
                          <td data-cell-title="Order #">12346</td>
                          <td data-cell-title="Date">March 24, 2021</td>
                          <td data-cell-title="Status">Approved</td>
                          <td data-cell-title="Total"><span class="mad-product-price">4.99</span></td>
                          <td data-cell-title="Actions"><a href="#" class="mad-link color-2">View</a></td>
                        </tr>
                        <tr>
                          <td data-cell-title="Order #">12347</td>
                          <td data-cell-title="Date">June 10, 2021</td>
                          <td data-cell-title="Status">Pending</td>
                          <td data-cell-title="Total"><span class="mad-product-price">14.99</span></td>
                          <td data-cell-title="Actions"><a href="#" class="mad-link color-2">View</a></td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="content-element-15">
                  <h3>My Dashboard</h3>
                  <div class="content-element-5">
                    <h6 class="mad-fw-semi">Hello, John Doe (not John Doe? <a href="#" class="mad-link color-2">Sign out</a>)
                    </h6>
                    <p class="mad-text-big">From your account dashboard you can view your recent orders, manage your shipping
                      and
                      billing addresses and <a href="#" class="mad-link color-2">edit your
                        password and account details</a>.</p>
                  </div>
                  <div class="content-element-5">
                    <h6 class="mad-fw-semi">My Address</h6>
                    <p class="mad-text-big">The following addresses will be used on the checkout page by default.</p>
                  </div>
                  <div class="content-element-5">
                    <div class="row">
                      <div class="col-sm-6">
                        <h6 class="mad-fw-semi">Billing Address</h6>
                        <p class="mad-text-big">
                          John Doe <br>
                          Green street <br>
                          12345 New York <br>
                          USA
                        </p>
                        <a href="#" class="btn btn-mini btn-style-2">Edit</a>
                      </div>
                      <div class="col-sm-6">
                        <h6 class="mad-fw-semi">Shipping Address</h6>
                        <p class="mad-text-big">
                          John Doe <br>
                          Green street <br>
                          12345 New York <br>
                          USA
                        </p>
                        <a href="#" class="btn btn-mini btn-style-2">Edit</a>
                      </div>
                    </div>
                  </div>
                </div>
              </main>
              <aside id="sidebar" class="col-xl-3 mad-sidebar">
                <div class="mad-widget">
                  <div class="shopping-cart">
                    <h5 class="mad-widget-title">Cart</h5>
                    <div class="mad-products mad-product-small">
                      <div class="mad-col">
                        <!-- Product -->
                        <div class="mad-product">
                          <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                          <a href="#" class="mad-product-image">
                            <img src="{{ asset('assets_front/images/72x72_img1.jpg') }}" alt="">
                          </a>
                          <!-- product-info -->
                          <div class="mad-product-description">
                            <h6 class="mad-product-title"><a href="#" class="mad-link">Chicken Burger</a></h6>
                            <span class="mad-product-price">1 × $14.99</span>
                          </div>
                          <!--/ product-info -->
                        </div>
                        <!-- End of Product -->
                      </div>
                      <div class="mad-col">
                        <!-- Product -->
                        <div class="mad-product">
                          <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                          <a href="#" class="mad-product-image">
                            <img src="{{ asset('assets_front/images/72x72_img2.jpg') }}" alt="">
                          </a>
                          <!-- product-info -->
                          <div class="mad-product-description">
                            <h6 class="mad-product-title"><a href="#" class="mad-link">Affogato</a></h6>
                            <span class="mad-product-price">1 x $4.99</span>
                          </div>
                          <!--/ product-info -->
                        </div>
                        <!-- End of Product -->
                      </div>
                      <div class="mad-col">
                        <!-- Product -->
                        <div class="mad-product">
                          <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                          <a href="#" class="mad-product-image">
                            <img src="{{ asset('assets_front/images/72x72_img3.jpg') }}" alt="">
                          </a>
                          <!-- product-info -->
                          <div class="mad-product-description">
                            <h6 class="mad-product-title"><a href="#" class="mad-link">Conchiglia
                                Verdura.</a></h6>
                            <span class="mad-product-price">1 x $14.99</span>
                          </div>
                          <!--/ product-info -->
                        </div>
                        <!-- End of Product -->
                      </div>
                    </div>
                    <div class="sc-footer">
                      <div class="subtotal">Subtotal: <span class="mad-price">34.97</span></div>
                      <a href="#" class="btn btn-small btn-style-3 w-100"><i class="material-icons">arrow_right_alt</i><span>Checkout</span></a>
                    </div>
                  </div>
                </div>
                <div class="mad-widget">
                  <h5 class="mad-widget-title">Design Your Pizza</h5>
                  <figure class="content-element-3"><img src="{{ asset('assets_front/images/318x216_img1.jpg') }}" alt=""></figure>
                  <div class="content-element-3">
                    <h6 class="mad-semi-title">Pizza</h6>
                    <p class="mad-text-small">Use our Roll Builder to make the most tasty roll for you – start with Add toppings
                      button.
                    </p>
                  </div>
                  <div class="btn-set small-btns">
                    <a href="#" class="btn btn-mini btn-style-3">Add Topping</a>
                    <a href="#" class="btn btn-mini btn-style-3">Add To Cart</a>
                  </div>
                </div>
              </aside>
            </div>
          </div>
        </div>
      </div>
      @endsection