<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function admin(Request $request)
    {
        if($request->session()->has('ADMIN_LOGIN')){
            return redirect('dashbord');
        }else{
            return view('admin/login');
        }
        return view('admin/login');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function auth(Request $request)
    {
        $name=$request->post('name');
        $password=$request->post('password');

        //  $result=Admin::where(['name'=>$name,'password'=>$password])->get();
        //  echo '<pre>';
        //  print_r($result);
         
        $result=Admin::where(['name'=>$name])->first();
        if($result){
            if(Hash::check($request->post('password'),$result->password)){
                $request->session()->put('ADMIN_LOGIN',true);
                $request->session()->put('ADMIN_ID',$result->id);
                return redirect('dashbord');
            }else{
                $request->session()->put('error','Please enter correct password');
                return redirect('admin');
            }
        }else{
            $request->session()->put('error','Please enter valid login details');
            return redirect('admin');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function dashbord(Request $request)
    {
        $product_counts = DB::table('products')->count();
        $order_counts = DB::table('add_to_carts')->where(['checkouts_id' => 1])->count();
        $total_customer = DB::table('custregisters')->count();
        //return view('admin/deshbord', compact('product_counts'), compact('order_counts') );
        return view('admin/deshbord', compact(['product_counts','order_counts','total_customer']) );
    }

  
    public function updatepassword()
     { 
     $r=Admin::find(1);
     $r->password=Hash::make('admin');
     $r->save();
     }

  
    public function edit(Admin $admin)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Admin $admin)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Admin  $admin
     * @return \Illuminate\Http\Response
     */
    public function destroy(Admin $admin)
    {
        //
    }
}
