@extends('admin_layout.adminlayout')
@section('title', 'Admin')
@include('admin_layout.header')
@include('admin_layout.sidebar')
@section('content')

<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <!-- Dashboard Ecommerce Starts -->
            <section id="dashboard-ecommerce">
                <div class="row match-height">
                    <!-- Medal Card -->
                    <!-- <div class="col-xl-4 col-md-6 col-12">
                        <div class="card card-congratulation-medal">
                            <div class="card-body">
                                <h5>Congratulations 🎉 John!</h5>
                                <p class="card-text font-small-3">You have won gold medal</p>
                                <h3 class="mb-75 mt-2 pt-50">
                                    <a href="#">$48.9k</a>
                                </h3>
                                <button type="button" class="btn btn-primary waves-effect waves-float waves-light">View Sales</button>
                                <img src="{{ asset('app-assets/images/illustration/badge.svg') }}" class="congratulation-medal" alt="Medal Pic">
                            </div>
                        </div>
                    </div> -->
                    <!--/ Medal Card -->

                    <!-- Statistics Card -->
                    <div class="col-xl-12 col-md-12 col-12">
                        <div class="statistics-card">
                            <div class="card-header">
                                <h4 class="card-title">Statistics</h4>
                                <!-- <div class="d-flex align-items-center">
                                    <p class="card-text font-small-2 me-25 mb-0">Updated 1 month ago</p>
                                </div> -->
                            </div>
                            <div class="statistics-card">
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <div>
                                                    <h2 class="fw-bolder mb-0">{{$order_counts}}</h2>
                                                    <p class="card-text">Orders</p>
                                                </div>
                                                <div class="avatar bg-light-primary p-50 m-0">
                                                    <div class="avatar-content">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-shopping-bag font-medium-5">
                                                            <path d="M6 2L3 6v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V6l-3-4z"></path>
                                                            <line x1="3" y1="6" x2="21" y2="6"></line>
                                                            <path d="M16 10a4 4 0 0 1-8 0"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <div>
                                                    <h2 class="fw-bolder mb-0">{{$product_counts}}</h2>
                                                    <p class="card-text">Products</p>
                                                </div>
                                                <div class="avatar bg-light-success p-50 m-0">
                                                    <div class="avatar-content">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-package font-medium-5">
                                                            <line x1="16.5" y1="9.4" x2="7.5" y2="4.21"></line>
                                                            <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                                                            <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
                                                            <line x1="12" y1="22.08" x2="12" y2="12"></line>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <div>
                                                    <h2 class="fw-bolder mb-0">{{$total_customer}}</h2>
                                                    <p class="card-text">Customer</p>
                                                </div>
                                                <div class="avatar bg-light-danger p-50 m-0">
                                                    <div class="avatar-content">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-users font-medium-5">
                                                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                                                            <circle cx="9" cy="7" r="4"></circle>
                                                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                                                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="card">
                                            <div class="card-header">
                                                <div>
                                                    <h2 class="fw-bolder mb-0">13</h2>
                                                    <p class="card-text">Issues Found</p>
                                                </div>
                                                <div class="avatar bg-light-warning p-50 m-0">
                                                    <div class="avatar-content">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-octagon font-medium-5">
                                                            <polygon points="7.86 2 16.14 2 22 7.86 22 16.14 16.14 22 7.86 22 2 16.14 2 7.86 7.86 2"></polygon>
                                                            <line x1="12" y1="8" x2="12" y2="12"></line>
                                                            <line x1="12" y1="16" x2="12.01" y2="16"></line>
                                                        </svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Statistics Card -->
                </div>

                <div class="row match-height">
                    <div class="col-lg-4 col-12">
                        <div class="row match-height">
                            <!-- Bar Chart - Orders -->
                            <div class="col-lg-6 col-md-3 col-6">
                                <div class="card">
                                    <div class="card-body pb-50" style="position: relative;">
                                        <h6>Orders</h6>
                                        <h2 class="fw-bolder mb-1">2,76k</h2>
                                        <div id="statistics-order-chart" style="min-height: 85px;">
                                            <div id="apexchartsvbf75zw6" class="apexcharts-canvas apexchartsvbf75zw6 apexcharts-theme-light" style="width: 133px; height: 70px;"><svg id="SvgjsSvg1774" width="133" height="70" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg apexcharts-zoomable" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1776" class="apexcharts-inner apexcharts-graphical" transform="translate(13.433333333333334, 15)">
                                                        <defs id="SvgjsDefs1775">
                                                            <linearGradient id="SvgjsLinearGradient1779" x1="0" y1="0" x2="0" y2="1">
                                                                <stop id="SvgjsStop1780" stop-opacity="0.4" stop-color="rgba(216,227,240,0.4)" offset="0"></stop>
                                                                <stop id="SvgjsStop1781" stop-opacity="0.5" stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                                <stop id="SvgjsStop1782" stop-opacity="0.5" stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                            </linearGradient>
                                                            <clipPath id="gridRectMaskvbf75zw6">
                                                                <rect id="SvgjsRect1784" width="137" height="55" x="-11.433333333333334" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMaskvbf75zw6">
                                                                <rect id="SvgjsRect1785" width="118.13333333333333" height="59" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <rect id="SvgjsRect1783" width="5.706666666666666" height="55" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke-dasharray="3" fill="url(#SvgjsLinearGradient1779)" class="apexcharts-xcrosshairs" y2="55" filter="none" fill-opacity="0.9"></rect>
                                                        <g id="SvgjsG1799" class="apexcharts-xaxis" transform="translate(0, 0)">
                                                            <g id="SvgjsG1800" class="apexcharts-xaxis-texts-g" transform="translate(0, -4)"></g>
                                                        </g>
                                                        <g id="SvgjsG1802" class="apexcharts-grid">
                                                            <g id="SvgjsG1803" class="apexcharts-gridlines-horizontal" style="display: none;">
                                                                <line id="SvgjsLine1805" x1="-9.433333333333334" y1="0" x2="123.56666666666666" y2="0" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1806" x1="-9.433333333333334" y1="11" x2="123.56666666666666" y2="11" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1807" x1="-9.433333333333334" y1="22" x2="123.56666666666666" y2="22" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1808" x1="-9.433333333333334" y1="33" x2="123.56666666666666" y2="33" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1809" x1="-9.433333333333334" y1="44" x2="123.56666666666666" y2="44" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1810" x1="-9.433333333333334" y1="55" x2="123.56666666666666" y2="55" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                            </g>
                                                            <g id="SvgjsG1804" class="apexcharts-gridlines-vertical" style="display: none;"></g>
                                                            <line id="SvgjsLine1812" x1="0" y1="55" x2="114.13333333333333" y2="55" stroke="transparent" stroke-dasharray="0"></line>
                                                            <line id="SvgjsLine1811" x1="0" y1="1" x2="0" y2="55" stroke="transparent" stroke-dasharray="0"></line>
                                                        </g>
                                                        <g id="SvgjsG1786" class="apexcharts-bar-series apexcharts-plot-series">
                                                            <g id="SvgjsG1787" class="apexcharts-series" seriesName="2020" rel="1" data:realIndex="0">
                                                                <rect id="SvgjsRect1789" width="5.706666666666666" height="55" x="-2.853333333333333" y="0" rx="5" ry="5" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#f3f3f3" class="apexcharts-backgroundBar"></rect>
                                                                <path id="SvgjsPath1790" d="M -2.853333333333333 53.57333333333333L -2.853333333333333 30.25L 2.853333333333333 30.25L 2.853333333333333 30.25L 2.853333333333333 53.57333333333333Q 0 56.42666666666666 -2.853333333333333 53.57333333333333z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskvbf75zw6)" pathTo="M -2.853333333333333 53.57333333333333L -2.853333333333333 30.25L 2.853333333333333 30.25L 2.853333333333333 30.25L 2.853333333333333 53.57333333333333Q 0 56.42666666666666 -2.853333333333333 53.57333333333333z" pathFrom="M -2.853333333333333 53.57333333333333L -2.853333333333333 55L 2.853333333333333 55L 2.853333333333333 55L 2.853333333333333 55L -2.853333333333333 55" cy="30.25" cx="2.8533333333333344" j="0" val="45" barHeight="24.75" barWidth="5.706666666666666"></path>
                                                                <rect id="SvgjsRect1791" width="5.706666666666666" height="55" x="25.68" y="0" rx="5" ry="5" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#f3f3f3" class="apexcharts-backgroundBar"></rect>
                                                                <path id="SvgjsPath1792" d="M 25.68 53.57333333333333L 25.68 8.25L 31.386666666666667 8.25L 31.386666666666667 8.25L 31.386666666666667 53.57333333333333Q 28.53333333333333 56.42666666666666 25.68 53.57333333333333z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskvbf75zw6)" pathTo="M 25.68 53.57333333333333L 25.68 8.25L 31.386666666666667 8.25L 31.386666666666667 8.25L 31.386666666666667 53.57333333333333Q 28.53333333333333 56.42666666666666 25.68 53.57333333333333z" pathFrom="M 25.68 53.57333333333333L 25.68 55L 31.386666666666667 55L 31.386666666666667 55L 31.386666666666667 55L 25.68 55" cy="8.25" cx="31.386666666666667" j="1" val="85" barHeight="46.75" barWidth="5.706666666666666"></path>
                                                                <rect id="SvgjsRect1793" width="5.706666666666666" height="55" x="54.21333333333333" y="0" rx="5" ry="5" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#f3f3f3" class="apexcharts-backgroundBar"></rect>
                                                                <path id="SvgjsPath1794" d="M 54.21333333333333 53.57333333333333L 54.21333333333333 19.25L 59.919999999999995 19.25L 59.919999999999995 19.25L 59.919999999999995 53.57333333333333Q 57.06666666666666 56.42666666666666 54.21333333333333 53.57333333333333z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskvbf75zw6)" pathTo="M 54.21333333333333 53.57333333333333L 54.21333333333333 19.25L 59.919999999999995 19.25L 59.919999999999995 19.25L 59.919999999999995 53.57333333333333Q 57.06666666666666 56.42666666666666 54.21333333333333 53.57333333333333z" pathFrom="M 54.21333333333333 53.57333333333333L 54.21333333333333 55L 59.919999999999995 55L 59.919999999999995 55L 59.919999999999995 55L 54.21333333333333 55" cy="19.25" cx="59.92" j="2" val="65" barHeight="35.75" barWidth="5.706666666666666"></path>
                                                                <rect id="SvgjsRect1795" width="5.706666666666666" height="55" x="82.74666666666666" y="0" rx="5" ry="5" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#f3f3f3" class="apexcharts-backgroundBar"></rect>
                                                                <path id="SvgjsPath1796" d="M 82.74666666666666 53.57333333333333L 82.74666666666666 30.25L 88.45333333333332 30.25L 88.45333333333332 30.25L 88.45333333333332 53.57333333333333Q 85.6 56.42666666666666 82.74666666666666 53.57333333333333z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskvbf75zw6)" pathTo="M 82.74666666666666 53.57333333333333L 82.74666666666666 30.25L 88.45333333333332 30.25L 88.45333333333332 30.25L 88.45333333333332 53.57333333333333Q 85.6 56.42666666666666 82.74666666666666 53.57333333333333z" pathFrom="M 82.74666666666666 53.57333333333333L 82.74666666666666 55L 88.45333333333332 55L 88.45333333333332 55L 88.45333333333332 55L 82.74666666666666 55" cy="30.25" cx="88.45333333333332" j="3" val="45" barHeight="24.75" barWidth="5.706666666666666"></path>
                                                                <rect id="SvgjsRect1797" width="5.706666666666666" height="55" x="111.27999999999999" y="0" rx="5" ry="5" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#f3f3f3" class="apexcharts-backgroundBar"></rect>
                                                                <path id="SvgjsPath1798" d="M 111.27999999999999 53.57333333333333L 111.27999999999999 19.25L 116.98666666666665 19.25L 116.98666666666665 19.25L 116.98666666666665 53.57333333333333Q 114.13333333333333 56.42666666666666 111.27999999999999 53.57333333333333z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskvbf75zw6)" pathTo="M 111.27999999999999 53.57333333333333L 111.27999999999999 19.25L 116.98666666666665 19.25L 116.98666666666665 19.25L 116.98666666666665 53.57333333333333Q 114.13333333333333 56.42666666666666 111.27999999999999 53.57333333333333z" pathFrom="M 111.27999999999999 53.57333333333333L 111.27999999999999 55L 116.98666666666665 55L 116.98666666666665 55L 116.98666666666665 55L 111.27999999999999 55" cy="19.25" cx="116.98666666666666" j="4" val="65" barHeight="35.75" barWidth="5.706666666666666"></path>
                                                            </g>
                                                            <g id="SvgjsG1788" class="apexcharts-datalabels" data:realIndex="0"></g>
                                                        </g>
                                                        <line id="SvgjsLine1813" x1="-9.433333333333334" y1="0" x2="123.56666666666666" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1814" x1="-9.433333333333334" y1="0" x2="123.56666666666666" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                        <g id="SvgjsG1815" class="apexcharts-yaxis-annotations"></g>
                                                        <g id="SvgjsG1816" class="apexcharts-xaxis-annotations"></g>
                                                        <g id="SvgjsG1817" class="apexcharts-point-annotations"></g>
                                                        <rect id="SvgjsRect1818" width="0" height="0" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fefefe" class="apexcharts-zoom-rect"></rect>
                                                        <rect id="SvgjsRect1819" width="0" height="0" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fefefe" class="apexcharts-selection-rect"></rect>
                                                    </g>
                                                    <g id="SvgjsG1801" class="apexcharts-yaxis" rel="0" transform="translate(-18, 0)"></g>
                                                    <g id="SvgjsG1777" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend" style="max-height: 35px;"></div>
                                                <div class="apexcharts-tooltip apexcharts-theme-light">
                                                    <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(255, 159, 67);"></span>
                                                        <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                            <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                            <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                    <div class="apexcharts-yaxistooltip-text"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 176px; height: 181px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--/ Bar Chart - Orders -->

                            <!-- Line Chart - Profit -->
                            <div class="col-lg-6 col-md-3 col-6">
                                <div class="card card-tiny-line-stats">
                                    <div class="card-body pb-50" style="position: relative;">
                                        <h6>Profit</h6>
                                        <h2 class="fw-bolder mb-1">6,24k</h2>
                                        <div id="statistics-profit-chart" style="min-height: 85px;">
                                            <div id="apexchartsp96j0chpf" class="apexcharts-canvas apexchartsp96j0chpf apexcharts-theme-light" style="width: 133px; height: 70px;"><svg id="SvgjsSvg1820" width="133" height="70" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1822" class="apexcharts-inner apexcharts-graphical" transform="translate(12, 0)">
                                                        <defs id="SvgjsDefs1821">
                                                            <clipPath id="gridRectMaskp96j0chpf">
                                                                <rect id="SvgjsRect1827" width="118" height="68" x="-3.5" y="-1.5" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMaskp96j0chpf">
                                                                <rect id="SvgjsRect1828" width="123" height="77" x="-6" y="-6" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <line id="SvgjsLine1826" x1="0" y1="0" x2="0" y2="65" stroke="#b6b6b6" stroke-dasharray="3" class="apexcharts-xcrosshairs" x="0" y="0" width="1" height="65" fill="#b1b9c4" filter="none" fill-opacity="0.9" stroke-width="1"></line>
                                                        <g id="SvgjsG1845" class="apexcharts-xaxis" transform="translate(0, 0)">
                                                            <g id="SvgjsG1846" class="apexcharts-xaxis-texts-g" transform="translate(0, -4)"><text id="SvgjsText1848" font-family="Helvetica, Arial, sans-serif" x="0" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1849">1</tspan>
                                                                    <title>1</title>
                                                                </text><text id="SvgjsText1851" font-family="Helvetica, Arial, sans-serif" x="22.199999999999996" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1852">2</tspan>
                                                                    <title>2</title>
                                                                </text><text id="SvgjsText1854" font-family="Helvetica, Arial, sans-serif" x="44.4" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1855">3</tspan>
                                                                    <title>3</title>
                                                                </text><text id="SvgjsText1857" font-family="Helvetica, Arial, sans-serif" x="66.60000000000001" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1858">4</tspan>
                                                                    <title>4</title>
                                                                </text><text id="SvgjsText1860" font-family="Helvetica, Arial, sans-serif" x="88.80000000000001" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1861">5</tspan>
                                                                    <title>5</title>
                                                                </text><text id="SvgjsText1863" font-family="Helvetica, Arial, sans-serif" x="111.00000000000001" y="94" text-anchor="middle" dominant-baseline="auto" font-size="0px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                    <tspan id="SvgjsTspan1864">6</tspan>
                                                                    <title>6</title>
                                                                </text></g>
                                                        </g>
                                                        <g id="SvgjsG1866" class="apexcharts-grid">
                                                            <g id="SvgjsG1867" class="apexcharts-gridlines-horizontal"></g>
                                                            <g id="SvgjsG1868" class="apexcharts-gridlines-vertical">
                                                                <line id="SvgjsLine1869" x1="0" y1="0" x2="0" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1870" x1="22.2" y1="0" x2="22.2" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1871" x1="44.4" y1="0" x2="44.4" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1872" x1="66.6" y1="0" x2="66.6" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1873" x1="88.8" y1="0" x2="88.8" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                                <line id="SvgjsLine1874" x1="111" y1="0" x2="111" y2="65" stroke="#ebebeb" stroke-dasharray="5" class="apexcharts-gridline"></line>
                                                            </g>
                                                            <line id="SvgjsLine1876" x1="0" y1="65" x2="111" y2="65" stroke="transparent" stroke-dasharray="0"></line>
                                                            <line id="SvgjsLine1875" x1="0" y1="1" x2="0" y2="65" stroke="transparent" stroke-dasharray="0"></line>
                                                        </g>
                                                        <g id="SvgjsG1829" class="apexcharts-line-series apexcharts-plot-series">
                                                            <g id="SvgjsG1830" class="apexcharts-series" seriesName="seriesx1" data:longestSeries="true" rel="1" data:realIndex="0">
                                                                <path id="SvgjsPath1844" d="M 0 65L 22.2 39L 44.4 58.5L 66.60000000000001 26L 88.8 45.5L 111 6.5" fill="none" fill-opacity="1" stroke="rgba(0,207,232,0.85)" stroke-opacity="1" stroke-linecap="butt" stroke-width="3" stroke-dasharray="0" class="apexcharts-line" index="0" clip-path="url(#gridRectMaskp96j0chpf)" pathTo="M 0 65L 22.2 39L 44.4 58.5L 66.60000000000001 26L 88.8 45.5L 111 6.5" pathFrom="M -1 65L -1 65L 22.2 65L 44.4 65L 66.60000000000001 65L 88.8 65L 111 65"></path>
                                                                <g id="SvgjsG1831" class="apexcharts-series-markers-wrap" data:realIndex="0">
                                                                    <g id="SvgjsG1833" class="apexcharts-series-markers" clip-path="url(#gridRectMarkerMaskp96j0chpf)">
                                                                        <circle id="SvgjsCircle1834" r="2" cx="0" cy="65" class="apexcharts-marker no-pointer-events wxi6n45olk" stroke="#00cfe8" fill="#00cfe8" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="0" j="0" index="0" default-marker-size="2"></circle>
                                                                        <circle id="SvgjsCircle1835" r="2" cx="22.2" cy="39" class="apexcharts-marker no-pointer-events ws243dk4z" stroke="#00cfe8" fill="#00cfe8" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="1" j="1" index="0" default-marker-size="2"></circle>
                                                                    </g>
                                                                    <g id="SvgjsG1836" class="apexcharts-series-markers" clip-path="url(#gridRectMarkerMaskp96j0chpf)">
                                                                        <circle id="SvgjsCircle1837" r="2" cx="44.4" cy="58.5" class="apexcharts-marker no-pointer-events wqzqe7io5" stroke="#00cfe8" fill="#00cfe8" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="2" j="2" index="0" default-marker-size="2"></circle>
                                                                    </g>
                                                                    <g id="SvgjsG1838" class="apexcharts-series-markers" clip-path="url(#gridRectMarkerMaskp96j0chpf)">
                                                                        <circle id="SvgjsCircle1839" r="2" cx="66.60000000000001" cy="26" class="apexcharts-marker no-pointer-events wzueaj57j" stroke="#00cfe8" fill="#00cfe8" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="3" j="3" index="0" default-marker-size="2"></circle>
                                                                    </g>
                                                                    <g id="SvgjsG1840" class="apexcharts-series-markers" clip-path="url(#gridRectMarkerMaskp96j0chpf)">
                                                                        <circle id="SvgjsCircle1841" r="2" cx="88.8" cy="45.5" class="apexcharts-marker no-pointer-events w11e27u3e" stroke="#00cfe8" fill="#00cfe8" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="4" j="4" index="0" default-marker-size="2"></circle>
                                                                    </g>
                                                                    <g id="SvgjsG1842" class="apexcharts-series-markers" clip-path="url(#gridRectMarkerMaskp96j0chpf)">
                                                                        <circle id="SvgjsCircle1843" r="5" cx="111" cy="6.5" class="apexcharts-marker no-pointer-events wisz7qzd8" stroke="#00cfe8" fill="#ffffff" fill-opacity="1" stroke-width="2" stroke-opacity="1" rel="5" j="5" index="0" default-marker-size="5"></circle>
                                                                    </g>
                                                                </g>
                                                            </g>
                                                            <g id="SvgjsG1832" class="apexcharts-datalabels" data:realIndex="0"></g>
                                                        </g>
                                                        <line id="SvgjsLine1877" x1="0" y1="0" x2="111" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1878" x1="0" y1="0" x2="111" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                        <g id="SvgjsG1879" class="apexcharts-yaxis-annotations"></g>
                                                        <g id="SvgjsG1880" class="apexcharts-xaxis-annotations"></g>
                                                        <g id="SvgjsG1881" class="apexcharts-point-annotations"></g>
                                                    </g>
                                                    <rect id="SvgjsRect1825" width="0" height="0" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fefefe"></rect>
                                                    <g id="SvgjsG1865" class="apexcharts-yaxis" rel="0" transform="translate(-18, 0)"></g>
                                                    <g id="SvgjsG1823" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend" style="max-height: 35px;"></div>
                                                <div class="apexcharts-tooltip apexcharts-theme-light">
                                                    <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(0, 207, 232);"></span>
                                                        <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                            <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                            <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="apexcharts-xaxistooltip apexcharts-xaxistooltip-bottom apexcharts-theme-light">
                                                    <div class="apexcharts-xaxistooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;"></div>
                                                </div>
                                                <div class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                    <div class="apexcharts-yaxistooltip-text"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 176px; height: 181px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--/ Line Chart - Profit -->

                            <!-- Earnings Card -->
                            <div class="col-lg-12 col-md-6 col-12">
                                <div class="card earnings-card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-6">
                                                <h4 class="card-title mb-1">Earnings</h4>
                                                <div class="font-small-2">This Month</div>
                                                <h5 class="mb-1">$4055.56</h5>
                                                <p class="card-text text-muted font-small-2">
                                                    <span class="fw-bolder">68.2%</span><span> more earnings than last month.</span>
                                                </p>
                                            </div>
                                            <div class="col-6" style="position: relative;">
                                                <div id="earnings-chart" style="min-height: 126.8px;">
                                                    <div id="apexchartschz3ets5" class="apexcharts-canvas apexchartschz3ets5 apexcharts-theme-light" style="width: 155px; height: 126.8px;"><svg id="SvgjsSvg1882" width="155" height="126.8" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                            <g id="SvgjsG1884" class="apexcharts-inner apexcharts-graphical" transform="translate(-2.5, 0)">
                                                                <defs id="SvgjsDefs1883">
                                                                    <clipPath id="gridRectMaskchz3ets5">
                                                                        <rect id="SvgjsRect1886" width="164" height="128" x="-2" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                                    </clipPath>
                                                                    <clipPath id="gridRectMarkerMaskchz3ets5">
                                                                        <rect id="SvgjsRect1887" width="164" height="132" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                                    </clipPath>
                                                                </defs>
                                                                <g id="SvgjsG1888" class="apexcharts-pie">
                                                                    <g id="SvgjsG1889" transform="translate(0, 0) scale(1)">
                                                                        <circle id="SvgjsCircle1890" r="37.98536585365854" cx="80" cy="64" fill="transparent"></circle>
                                                                        <g id="SvgjsG1891" class="apexcharts-slices">
                                                                            <g id="SvgjsG1892" class="apexcharts-series apexcharts-pie-series" seriesName="App" rel="1" data:realIndex="0">
                                                                                <path id="SvgjsPath1893" d="M 69.85216991000085 6.448795702018273 A 58.43902439024391 58.43902439024391 0 1 1 79.1840638026197 122.43332798844617 L 79.46964147170281 101.98166319249002 A 37.98536585365854 37.98536585365854 0 1 0 73.40391044150056 26.591717206311877 L 69.85216991000085 6.448795702018273 z" fill="#28c76f66" fill-opacity="1" stroke-opacity="1" stroke-linecap="butt" stroke-width="0" stroke-dasharray="0" class="apexcharts-pie-area apexcharts-donut-slice-0" index="0" j="0" data:angle="190.8" data:startAngle="-10" data:strokeWidth="0" data:value="53" data:pathOrig="M 69.85216991000085 6.448795702018273 A 58.43902439024391 58.43902439024391 0 1 1 79.1840638026197 122.43332798844617 L 79.46964147170281 101.98166319249002 A 37.98536585365854 37.98536585365854 0 1 0 73.40391044150056 26.591717206311877 L 69.85216991000085 6.448795702018273 z"></path>
                                                                            </g>
                                                                            <g id="SvgjsG1894" class="apexcharts-series apexcharts-pie-series" seriesName="Service" rel="2" data:realIndex="1">
                                                                                <path id="SvgjsPath1895" d="M 79.1840638026197 122.43332798844617 A 58.43902439024391 58.43902439024391 0 0 1 30.22590892178677 94.6212251391295 L 47.646840799161396 83.90379634043418 A 37.98536585365854 37.98536585365854 0 0 0 79.46964147170281 101.98166319249002 L 79.1840638026197 122.43332798844617 z" fill="#28c76f33" fill-opacity="1" stroke-opacity="1" stroke-linecap="butt" stroke-width="0" stroke-dasharray="0" class="apexcharts-pie-area apexcharts-donut-slice-1" index="0" j="1" data:angle="57.599999999999994" data:startAngle="180.8" data:strokeWidth="0" data:value="16" data:pathOrig="M 79.1840638026197 122.43332798844617 A 58.43902439024391 58.43902439024391 0 0 1 30.22590892178677 94.6212251391295 L 47.646840799161396 83.90379634043418 A 37.98536585365854 37.98536585365854 0 0 0 79.46964147170281 101.98166319249002 L 79.1840638026197 122.43332798844617 z"></path>
                                                                            </g>
                                                                            <g id="SvgjsG1896" class="apexcharts-series apexcharts-pie-series" seriesName="Product" rel="3" data:realIndex="2">
                                                                                <path id="SvgjsPath1897" d="M 30.22590892178677 94.6212251391295 A 58.43902439024391 58.43902439024391 0 0 1 69.84212548457727 6.4505677090342814 L 73.39738156497522 26.592869010872285 A 37.98536585365854 37.98536585365854 0 0 0 47.646840799161396 83.90379634043418 L 30.22590892178677 94.6212251391295 z" fill="rgba(40,199,111,1)" fill-opacity="1" stroke-opacity="1" stroke-linecap="butt" stroke-width="0" stroke-dasharray="0" class="apexcharts-pie-area apexcharts-donut-slice-2" index="0" j="2" data:angle="111.6" data:startAngle="238.4" data:strokeWidth="0" data:value="31" data:pathOrig="M 30.22590892178677 94.6212251391295 A 58.43902439024391 58.43902439024391 0 0 1 69.84212548457727 6.4505677090342814 L 73.39738156497522 26.592869010872285 A 37.98536585365854 37.98536585365854 0 0 0 47.646840799161396 83.90379634043418 L 30.22590892178677 94.6212251391295 z"></path>
                                                                            </g>
                                                                        </g>
                                                                    </g>
                                                                    <g id="SvgjsG1898" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)"><text id="SvgjsText1899" font-family="Helvetica, Arial, sans-serif" x="80" y="79" text-anchor="middle" dominant-baseline="auto" font-size="16px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-datalabel-label" style="font-family: Helvetica, Arial, sans-serif;">App</text><text id="SvgjsText1900" font-family="Helvetica, Arial, sans-serif" x="80" y="65" text-anchor="middle" dominant-baseline="auto" font-size="20px" font-weight="400" fill="#373d3f" class="apexcharts-text apexcharts-datalabel-value" style="font-family: Helvetica, Arial, sans-serif;">53%</text></g>
                                                                </g>
                                                                <line id="SvgjsLine1901" x1="0" y1="0" x2="160" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                                <line id="SvgjsLine1902" x1="0" y1="0" x2="160" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                            </g>
                                                            <g id="SvgjsG1885" class="apexcharts-annotations"></g>
                                                        </svg>
                                                        <div class="apexcharts-legend"></div>
                                                        <div class="apexcharts-tooltip apexcharts-theme-dark">
                                                            <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgba(40, 199, 111, 0.4);"></span>
                                                                <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                                    <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                                    <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                                </div>
                                                            </div>
                                                            <div class="apexcharts-tooltip-series-group" style="order: 2;"><span class="apexcharts-tooltip-marker" style="background-color: rgba(40, 199, 111, 0.2);"></span>
                                                                <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                                    <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                                    <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                                </div>
                                                            </div>
                                                            <div class="apexcharts-tooltip-series-group" style="order: 3;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(40, 199, 111);"></span>
                                                                <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                                    <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                                    <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="resize-triggers">
                                                    <div class="expand-trigger">
                                                        <div style="width: 184px; height: 128px;"></div>
                                                    </div>
                                                    <div class="contract-trigger"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--/ Earnings Card -->
                        </div>
                    </div>

                    <!-- Revenue Report Card -->
                    <div class="col-lg-8 col-12">
                        <div class="card card-revenue-budget">
                            <div class="row mx-0">
                                <div class="col-md-8 col-12 revenue-report-wrapper" style="position: relative;">
                                    <div class="d-sm-flex justify-content-between align-items-center mb-3">
                                        <h4 class="card-title mb-50 mb-sm-0">Revenue Report</h4>
                                        <div class="d-flex align-items-center">
                                            <div class="d-flex align-items-center me-2">
                                                <span class="bullet bullet-primary font-small-3 me-50 cursor-pointer"></span>
                                                <span>Earning</span>
                                            </div>
                                            <div class="d-flex align-items-center ms-75">
                                                <span class="bullet bullet-warning font-small-3 me-50 cursor-pointer"></span>
                                                <span>Expense</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="revenue-report-chart" style="min-height: 245px;">
                                        <div id="apexchartsjooodifl" class="apexcharts-canvas apexchartsjooodifl apexcharts-theme-light" style="width: 484px; height: 230px;"><svg id="SvgjsSvg1975" width="484" height="230" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                <g id="SvgjsG1977" class="apexcharts-inner apexcharts-graphical" transform="translate(54.77499961853027, 10)">
                                                    <defs id="SvgjsDefs1976">
                                                        <linearGradient id="SvgjsLinearGradient1981" x1="0" y1="0" x2="0" y2="1">
                                                            <stop id="SvgjsStop1982" stop-opacity="0.4" stop-color="rgba(216,227,240,0.4)" offset="0"></stop>
                                                            <stop id="SvgjsStop1983" stop-opacity="0.5" stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                            <stop id="SvgjsStop1984" stop-opacity="0.5" stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                        </linearGradient>
                                                        <clipPath id="gridRectMaskjooodifl">
                                                            <rect id="SvgjsRect1986" width="423.2250003814697" height="190.40640030860902" x="-2" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                        </clipPath>
                                                        <clipPath id="gridRectMarkerMaskjooodifl">
                                                            <rect id="SvgjsRect1987" width="423.2250003814697" height="194.40640030860902" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                        </clipPath>
                                                    </defs>
                                                    <rect id="SvgjsRect1985" width="7.918694451649983" height="190.40640030860902" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke-dasharray="3" fill="url(#SvgjsLinearGradient1981)" class="apexcharts-xcrosshairs" y2="190.40640030860902" filter="none" fill-opacity="0.9"></rect>
                                                    <g id="SvgjsG2011" class="apexcharts-xaxis" transform="translate(0, 0)">
                                                        <g id="SvgjsG2012" class="apexcharts-xaxis-texts-g" transform="translate(0, -4)"><text id="SvgjsText2014" font-family="Helvetica, Arial, sans-serif" x="23.29027779897054" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2015">Jan</tspan>
                                                                <title>Jan</title>
                                                            </text><text id="SvgjsText2017" font-family="Helvetica, Arial, sans-serif" x="69.87083339691162" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2018">Feb</tspan>
                                                                <title>Feb</title>
                                                            </text><text id="SvgjsText2020" font-family="Helvetica, Arial, sans-serif" x="116.4513889948527" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2021">Mar</tspan>
                                                                <title>Mar</title>
                                                            </text><text id="SvgjsText2023" font-family="Helvetica, Arial, sans-serif" x="163.03194459279376" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2024">Apr</tspan>
                                                                <title>Apr</title>
                                                            </text><text id="SvgjsText2026" font-family="Helvetica, Arial, sans-serif" x="209.61250019073483" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2027">May</tspan>
                                                                <title>May</title>
                                                            </text><text id="SvgjsText2029" font-family="Helvetica, Arial, sans-serif" x="256.19305578867596" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2030">Jun</tspan>
                                                                <title>Jun</title>
                                                            </text><text id="SvgjsText2032" font-family="Helvetica, Arial, sans-serif" x="302.77361138661706" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2033">Jul</tspan>
                                                                <title>Jul</title>
                                                            </text><text id="SvgjsText2035" font-family="Helvetica, Arial, sans-serif" x="349.35416698455816" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2036">Aug</tspan>
                                                                <title>Aug</title>
                                                            </text><text id="SvgjsText2038" font-family="Helvetica, Arial, sans-serif" x="395.93472258249926" y="219.40640030860902" text-anchor="middle" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-xaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan2039">Sep</tspan>
                                                                <title>Sep</title>
                                                            </text></g>
                                                    </g>
                                                    <g id="SvgjsG2054" class="apexcharts-grid">
                                                        <g id="SvgjsG2055" class="apexcharts-gridlines-horizontal"></g>
                                                        <g id="SvgjsG2056" class="apexcharts-gridlines-vertical"></g>
                                                        <line id="SvgjsLine2058" x1="0" y1="190.40640030860902" x2="419.2250003814697" y2="190.40640030860902" stroke="transparent" stroke-dasharray="0"></line>
                                                        <line id="SvgjsLine2057" x1="0" y1="1" x2="0" y2="190.40640030860902" stroke="transparent" stroke-dasharray="0"></line>
                                                    </g>
                                                    <g id="SvgjsG1988" class="apexcharts-bar-series apexcharts-plot-series">
                                                        <g id="SvgjsG1989" class="apexcharts-series" seriesName="Earning" rel="1" data:realIndex="0">
                                                            <path id="SvgjsPath1991" d="M 19.330930573145547 114.24384018516541L 19.330930573145547 80.04629773944218Q 23.29027779897054 76.0869505136172 27.24962502479553 80.04629773944218L 27.24962502479553 80.04629773944218L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 19.330930573145547 114.24384018516541L 19.330930573145547 80.04629773944218Q 23.29027779897054 76.0869505136172 27.24962502479553 80.04629773944218L 27.24962502479553 80.04629773944218L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541z" pathFrom="M 19.330930573145547 114.24384018516541L 19.330930573145547 114.24384018516541L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541L 19.330930573145547 114.24384018516541" cy="78.06662412652969" cx="65.91148617108662" j="0" val="95" barHeight="36.177216058635715" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1992" d="M 65.91148617108662 114.24384018516541L 65.91148617108662 48.819648088830306Q 69.8708333969116 44.860300863005314 73.8301806227366 48.819648088830306L 73.8301806227366 48.819648088830306L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 65.91148617108662 114.24384018516541L 65.91148617108662 48.819648088830306Q 69.8708333969116 44.860300863005314 73.8301806227366 48.819648088830306L 73.8301806227366 48.819648088830306L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541z" pathFrom="M 65.91148617108662 114.24384018516541L 65.91148617108662 114.24384018516541L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541L 65.91148617108662 114.24384018516541" cy="46.83997447591781" cx="112.49204176902771" j="1" val="177" barHeight="67.4038657092476" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1993" d="M 112.49204176902771 114.24384018516541L 112.49204176902771 8.072678422787977Q 116.45138899485269 4.113331196962985 120.41073622067769 8.072678422787977L 120.41073622067769 8.072678422787977L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 112.49204176902771 114.24384018516541L 112.49204176902771 8.072678422787977Q 116.45138899485269 4.113331196962985 120.41073622067769 8.072678422787977L 120.41073622067769 8.072678422787977L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541z" pathFrom="M 112.49204176902771 114.24384018516541L 112.49204176902771 114.24384018516541L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541L 112.49204176902771 114.24384018516541" cy="6.093004809875481" cx="159.07259736696878" j="2" val="284" barHeight="108.15083537528993" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1994" d="M 159.07259736696878 114.24384018516541L 159.07259736696878 18.735436840070083Q 163.03194459279376 14.776089614245091 166.99129181861875 18.735436840070083L 166.99129181861875 18.735436840070083L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 159.07259736696878 114.24384018516541L 159.07259736696878 18.735436840070083Q 163.03194459279376 14.776089614245091 166.99129181861875 18.735436840070083L 166.99129181861875 18.735436840070083L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541z" pathFrom="M 159.07259736696878 114.24384018516541L 159.07259736696878 114.24384018516541L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541L 159.07259736696878 114.24384018516541" cy="16.755763227157587" cx="205.65315296490985" j="3" val="256" barHeight="97.48807695800782" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1995" d="M 205.65315296490985 114.24384018516541L 205.65315296490985 76.23816973327Q 209.61250019073483 72.27882250744501 213.57184741655982 76.23816973327L 213.57184741655982 76.23816973327L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 205.65315296490985 114.24384018516541L 205.65315296490985 76.23816973327Q 209.61250019073483 72.27882250744501 213.57184741655982 76.23816973327L 213.57184741655982 76.23816973327L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541z" pathFrom="M 205.65315296490985 114.24384018516541L 205.65315296490985 114.24384018516541L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541L 205.65315296490985 114.24384018516541" cy="74.2584961203575" cx="252.23370856285092" j="4" val="105" barHeight="39.9853440648079" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1996" d="M 252.23370856285092 114.24384018516541L 252.23370856285092 92.23230735919317Q 256.1930557886759 88.27296013336819 260.1524030145009 92.23230735919317L 260.1524030145009 92.23230735919317L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 252.23370856285092 114.24384018516541L 252.23370856285092 92.23230735919317Q 256.1930557886759 88.27296013336819 260.1524030145009 92.23230735919317L 260.1524030145009 92.23230735919317L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541z" pathFrom="M 252.23370856285092 114.24384018516541L 252.23370856285092 114.24384018516541L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541L 252.23370856285092 114.24384018516541" cy="90.25263374628068" cx="298.814264160792" j="5" val="63" barHeight="23.99120643888474" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1997" d="M 298.814264160792 114.24384018516541L 298.814264160792 52.24696329438527Q 302.773611386617 48.287616068560276 306.73295861244196 52.24696329438527L 306.73295861244196 52.24696329438527L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 298.814264160792 114.24384018516541L 298.814264160792 52.24696329438527Q 302.773611386617 48.287616068560276 306.73295861244196 52.24696329438527L 306.73295861244196 52.24696329438527L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541z" pathFrom="M 298.814264160792 114.24384018516541L 298.814264160792 114.24384018516541L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541L 298.814264160792 114.24384018516541" cy="50.267289681472775" cx="345.3948197587331" j="6" val="168" barHeight="63.976550503692636" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1998" d="M 345.3948197587331 114.24384018516541L 345.3948197587331 33.20632326352437Q 349.3541669845581 29.246976037699376 353.31351421038306 33.20632326352437L 353.31351421038306 33.20632326352437L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 345.3948197587331 114.24384018516541L 345.3948197587331 33.20632326352437Q 349.3541669845581 29.246976037699376 353.31351421038306 33.20632326352437L 353.31351421038306 33.20632326352437L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541z" pathFrom="M 345.3948197587331 114.24384018516541L 345.3948197587331 114.24384018516541L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541L 345.3948197587331 114.24384018516541" cy="31.226649650611876" cx="391.9753753566742" j="7" val="218" barHeight="83.01719053455354" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath1999" d="M 391.9753753566742 114.24384018516541L 391.9753753566742 88.8049921536382Q 395.9347225824992 84.84564492781321 399.89406980832416 88.8049921536382L 399.89406980832416 88.8049921536382L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541z" fill="rgba(115,103,240,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="0" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 391.9753753566742 114.24384018516541L 391.9753753566742 88.8049921536382Q 395.9347225824992 84.84564492781321 399.89406980832416 88.8049921536382L 399.89406980832416 88.8049921536382L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541z" pathFrom="M 391.9753753566742 114.24384018516541L 391.9753753566742 114.24384018516541L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541L 391.9753753566742 114.24384018516541" cy="86.8253185407257" cx="438.5559309546153" j="8" val="72" barHeight="27.4185216444397" barWidth="7.918694451649983"></path>
                                                        </g>
                                                        <g id="SvgjsG2000" class="apexcharts-series" seriesName="Expense" rel="2" data:realIndex="1">
                                                            <path id="SvgjsPath2002" d="M 19.330930573145547 114.24384018516541L 19.330930573145547 167.4820226617495Q 23.29027779897054 171.4413698875745 27.24962502479553 167.4820226617495L 27.24962502479553 167.4820226617495L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 19.330930573145547 114.24384018516541L 19.330930573145547 167.4820226617495Q 23.29027779897054 171.4413698875745 27.24962502479553 167.4820226617495L 27.24962502479553 167.4820226617495L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541z" pathFrom="M 19.330930573145547 114.24384018516541L 19.330930573145547 114.24384018516541L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541L 27.24962502479553 114.24384018516541L 19.330930573145547 114.24384018516541" cy="169.46169627466202" cx="65.91148617108662" j="0" val="-145" barHeight="-55.21785608949662" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2003" d="M 65.91148617108662 114.24384018516541L 65.91148617108662 142.72919062163035Q 69.8708333969116 146.68853784745534 73.8301806227366 142.72919062163035L 73.8301806227366 142.72919062163035L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 65.91148617108662 114.24384018516541L 65.91148617108662 142.72919062163035Q 69.8708333969116 146.68853784745534 73.8301806227366 142.72919062163035L 73.8301806227366 142.72919062163035L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541z" pathFrom="M 65.91148617108662 114.24384018516541L 65.91148617108662 114.24384018516541L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541L 73.8301806227366 114.24384018516541L 65.91148617108662 114.24384018516541" cy="144.70886423454286" cx="112.49204176902771" j="1" val="-80" barHeight="-30.465024049377444" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2004" d="M 112.49204176902771 114.24384018516541L 112.49204176902771 135.112934609286Q 116.45138899485269 139.07228183511097 120.41073622067769 135.112934609286L 120.41073622067769 135.112934609286L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 112.49204176902771 114.24384018516541L 112.49204176902771 135.112934609286Q 116.45138899485269 139.07228183511097 120.41073622067769 135.112934609286L 120.41073622067769 135.112934609286L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541z" pathFrom="M 112.49204176902771 114.24384018516541L 112.49204176902771 114.24384018516541L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541L 120.41073622067769 114.24384018516541L 112.49204176902771 114.24384018516541" cy="137.0926082221985" cx="159.07259736696878" j="2" val="-60" barHeight="-22.848768037033086" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2005" d="M 159.07259736696878 114.24384018516541L 159.07259736696878 180.81047068335215Q 163.03194459279376 184.76981790917714 166.99129181861875 180.81047068335215L 166.99129181861875 180.81047068335215L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 159.07259736696878 114.24384018516541L 159.07259736696878 180.81047068335215Q 163.03194459279376 184.76981790917714 166.99129181861875 180.81047068335215L 166.99129181861875 180.81047068335215L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541z" pathFrom="M 159.07259736696878 114.24384018516541L 159.07259736696878 114.24384018516541L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541L 166.99129181861875 114.24384018516541L 159.07259736696878 114.24384018516541" cy="182.79014429626466" cx="205.65315296490985" j="3" val="-180" barHeight="-68.54630411109925" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2006" d="M 205.65315296490985 114.24384018516541L 205.65315296490985 150.34544663397472Q 209.61250019073483 154.3047938597997 213.57184741655982 150.34544663397472L 213.57184741655982 150.34544663397472L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 205.65315296490985 114.24384018516541L 205.65315296490985 150.34544663397472Q 209.61250019073483 154.3047938597997 213.57184741655982 150.34544663397472L 213.57184741655982 150.34544663397472L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541z" pathFrom="M 205.65315296490985 114.24384018516541L 205.65315296490985 114.24384018516541L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541L 213.57184741655982 114.24384018516541L 205.65315296490985 114.24384018516541" cy="152.32512024688722" cx="252.23370856285092" j="4" val="-100" barHeight="-38.081280061721806" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2007" d="M 252.23370856285092 114.24384018516541L 252.23370856285092 135.112934609286Q 256.1930557886759 139.07228183511097 260.1524030145009 135.112934609286L 260.1524030145009 135.112934609286L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 252.23370856285092 114.24384018516541L 252.23370856285092 135.112934609286Q 256.1930557886759 139.07228183511097 260.1524030145009 135.112934609286L 260.1524030145009 135.112934609286L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541z" pathFrom="M 252.23370856285092 114.24384018516541L 252.23370856285092 114.24384018516541L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541L 260.1524030145009 114.24384018516541L 252.23370856285092 114.24384018516541" cy="137.0926082221985" cx="298.814264160792" j="5" val="-60" barHeight="-22.848768037033086" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2008" d="M 298.814264160792 114.24384018516541L 298.814264160792 144.63325462471644Q 302.773611386617 148.59260185054143 306.73295861244196 144.63325462471644L 306.73295861244196 144.63325462471644L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 298.814264160792 114.24384018516541L 298.814264160792 144.63325462471644Q 302.773611386617 148.59260185054143 306.73295861244196 144.63325462471644L 306.73295861244196 144.63325462471644L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541z" pathFrom="M 298.814264160792 114.24384018516541L 298.814264160792 114.24384018516541L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541L 306.73295861244196 114.24384018516541L 298.814264160792 114.24384018516541" cy="146.61292823762895" cx="345.3948197587331" j="6" val="-85" barHeight="-32.36908805246354" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2009" d="M 345.3948197587331 114.24384018516541L 345.3948197587331 140.82512661854426Q 349.3541669845581 144.78447384436924 353.31351421038306 140.82512661854426L 353.31351421038306 140.82512661854426L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 345.3948197587331 114.24384018516541L 345.3948197587331 140.82512661854426Q 349.3541669845581 144.78447384436924 353.31351421038306 140.82512661854426L 353.31351421038306 140.82512661854426L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541z" pathFrom="M 345.3948197587331 114.24384018516541L 345.3948197587331 114.24384018516541L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541L 353.31351421038306 114.24384018516541L 345.3948197587331 114.24384018516541" cy="142.80480023145677" cx="391.9753753566742" j="7" val="-75" barHeight="-28.560960046291356" barWidth="7.918694451649983"></path>
                                                            <path id="SvgjsPath2010" d="M 391.9753753566742 114.24384018516541L 391.9753753566742 150.34544663397472Q 395.9347225824992 154.3047938597997 399.89406980832416 150.34544663397472L 399.89406980832416 150.34544663397472L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541z" fill="rgba(255,159,67,0.85)" fill-opacity="1" stroke-opacity="1" stroke-linecap="square" stroke-width="0" stroke-dasharray="0" class="apexcharts-bar-area" index="1" clip-path="url(#gridRectMaskjooodifl)" pathTo="M 391.9753753566742 114.24384018516541L 391.9753753566742 150.34544663397472Q 395.9347225824992 154.3047938597997 399.89406980832416 150.34544663397472L 399.89406980832416 150.34544663397472L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541z" pathFrom="M 391.9753753566742 114.24384018516541L 391.9753753566742 114.24384018516541L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541L 399.89406980832416 114.24384018516541L 391.9753753566742 114.24384018516541" cy="152.32512024688722" cx="438.5559309546153" j="8" val="-100" barHeight="-38.081280061721806" barWidth="7.918694451649983"></path>
                                                        </g>
                                                        <g id="SvgjsG1990" class="apexcharts-datalabels" data:realIndex="0"></g>
                                                        <g id="SvgjsG2001" class="apexcharts-datalabels" data:realIndex="1"></g>
                                                    </g>
                                                    <line id="SvgjsLine2059" x1="0" y1="0" x2="419.2250003814697" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                    <line id="SvgjsLine2060" x1="0" y1="0" x2="419.2250003814697" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    <g id="SvgjsG2061" class="apexcharts-yaxis-annotations"></g>
                                                    <g id="SvgjsG2062" class="apexcharts-xaxis-annotations"></g>
                                                    <g id="SvgjsG2063" class="apexcharts-point-annotations"></g>
                                                </g>
                                                <g id="SvgjsG2040" class="apexcharts-yaxis" rel="0" transform="translate(24.774999618530273, 0)">
                                                    <g id="SvgjsG2041" class="apexcharts-yaxis-texts-g"><text id="SvgjsText2042" font-family="Helvetica, Arial, sans-serif" x="20" y="11.5" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2043">300</tspan>
                                                        </text><text id="SvgjsText2044" font-family="Helvetica, Arial, sans-serif" x="20" y="49.581280061721806" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2045">200</tspan>
                                                        </text><text id="SvgjsText2046" font-family="Helvetica, Arial, sans-serif" x="20" y="87.66256012344361" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2047">100</tspan>
                                                        </text><text id="SvgjsText2048" font-family="Helvetica, Arial, sans-serif" x="20" y="125.74384018516542" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2049">0</tspan>
                                                        </text><text id="SvgjsText2050" font-family="Helvetica, Arial, sans-serif" x="20" y="163.82512024688722" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2051">-100</tspan>
                                                        </text><text id="SvgjsText2052" font-family="Helvetica, Arial, sans-serif" x="20" y="201.90640030860902" text-anchor="end" dominant-baseline="auto" font-size="0.86rem" font-weight="400" fill="#b9b9c3" class="apexcharts-text apexcharts-yaxis-label " style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan2053">-200</tspan>
                                                        </text></g>
                                                </g>
                                                <g id="SvgjsG1978" class="apexcharts-annotations"></g>
                                            </svg>
                                            <div class="apexcharts-legend" style="max-height: 115px;"></div>
                                            <div class="apexcharts-tooltip apexcharts-theme-light">
                                                <div class="apexcharts-tooltip-title" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;"></div>
                                                <div class="apexcharts-tooltip-series-group" style="order: 1;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(115, 103, 240);"></span>
                                                    <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                        <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                        <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                    </div>
                                                </div>
                                                <div class="apexcharts-tooltip-series-group" style="order: 2;"><span class="apexcharts-tooltip-marker" style="background-color: rgb(255, 159, 67);"></span>
                                                    <div class="apexcharts-tooltip-text" style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                        <div class="apexcharts-tooltip-y-group"><span class="apexcharts-tooltip-text-label"></span><span class="apexcharts-tooltip-text-value"></span></div>
                                                        <div class="apexcharts-tooltip-z-group"><span class="apexcharts-tooltip-text-z-label"></span><span class="apexcharts-tooltip-text-z-value"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                <div class="apexcharts-yaxistooltip-text"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="resize-triggers">
                                        <div class="expand-trigger">
                                            <div style="width: 527px; height: 346px;"></div>
                                        </div>
                                        <div class="contract-trigger"></div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-12 budget-wrapper" style="position: relative;">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-outline-primary btn-sm dropdown-toggle budget-dropdown waves-effect" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            2020
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">2020</a>
                                            <a class="dropdown-item" href="#">2019</a>
                                            <a class="dropdown-item" href="#">2018</a>
                                        </div>
                                    </div>
                                    <h2 class="mb-25">$25,852</h2>
                                    <div class="d-flex justify-content-center">
                                        <span class="fw-bolder me-25">Budget:</span>
                                        <span>56,800</span>
                                    </div>
                                    <div id="budget-chart" style="min-height: 80px;">
                                        <div id="apexchartsvr6m1p7zh" class="apexcharts-canvas apexchartsvr6m1p7zh apexcharts-theme-light" style="width: 180px; height: 80px;"><svg id="SvgjsSvg1939" width="180" height="80" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                <g id="SvgjsG1941" class="apexcharts-inner apexcharts-graphical" transform="translate(0, 0)">
                                                    <defs id="SvgjsDefs1940">
                                                        <clipPath id="gridRectMaskvr6m1p7zh">
                                                            <rect id="SvgjsRect1946" width="186" height="82" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                        </clipPath>
                                                        <clipPath id="gridRectMarkerMaskvr6m1p7zh">
                                                            <rect id="SvgjsRect1947" width="184" height="84" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                        </clipPath>
                                                    </defs>
                                                    <line id="SvgjsLine1945" x1="0" y1="0" x2="0" y2="80" stroke="#b6b6b6" stroke-dasharray="3" class="apexcharts-xcrosshairs" x="0" y="0" width="1" height="80" fill="#b1b9c4" filter="none" fill-opacity="0.9" stroke-width="1"></line>
                                                    <g id="SvgjsG1957" class="apexcharts-xaxis" transform="translate(0, 0)">
                                                        <g id="SvgjsG1958" class="apexcharts-xaxis-texts-g" transform="translate(0, -4)"></g>
                                                    </g>
                                                    <g id="SvgjsG1960" class="apexcharts-grid">
                                                        <g id="SvgjsG1961" class="apexcharts-gridlines-horizontal" style="display: none;">
                                                            <line id="SvgjsLine1963" x1="0" y1="0" x2="180" y2="0" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1964" x1="0" y1="20" x2="180" y2="20" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1965" x1="0" y1="40" x2="180" y2="40" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1966" x1="0" y1="60" x2="180" y2="60" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1967" x1="0" y1="80" x2="180" y2="80" stroke="#e0e0e0" stroke-dasharray="0" class="apexcharts-gridline"></line>
                                                        </g>
                                                        <g id="SvgjsG1962" class="apexcharts-gridlines-vertical" style="display: none;"></g>
                                                        <line id="SvgjsLine1969" x1="0" y1="80" x2="180" y2="80" stroke="transparent" stroke-dasharray="0"></line>
                                                        <line id="SvgjsLine1968" x1="0" y1="1" x2="0" y2="80" stroke="transparent" stroke-dasharray="0"></line>
                                                    </g>
                                                    <g id="SvgjsG1948" class="apexcharts-line-series apexcharts-plot-series">
                                                        <g id="SvgjsG1949" class="apexcharts-series" seriesName="seriesx1" data:longestSeries="true" rel="1" data:realIndex="0">
                                                            <path id="SvgjsPath1952" d="M 0 19C 6.3 19 11.7 32 18 32C 24.3 32 29.7 11 36 11C 42.3 11 47.7 28 54 28C 60.3 28 65.7 20 72 20C 78.3 20 83.7 40 90 40C 96.3 40 101.7 1 108 1C 114.3 1 119.7 20 126 20C 132.3 20 137.7 21 144 21C 150.3 21 155.7 37 162 37C 168.3 37 173.7 18 180 18" fill="none" fill-opacity="1" stroke="rgba(115,103,240,0.85)" stroke-opacity="1" stroke-linecap="butt" stroke-width="2" stroke-dasharray="0" class="apexcharts-line" index="0" clip-path="url(#gridRectMaskvr6m1p7zh)" pathTo="M 0 19C 6.3 19 11.7 32 18 32C 24.3 32 29.7 11 36 11C 42.3 11 47.7 28 54 28C 60.3 28 65.7 20 72 20C 78.3 20 83.7 40 90 40C 96.3 40 101.7 1 108 1C 114.3 1 119.7 20 126 20C 132.3 20 137.7 21 144 21C 150.3 21 155.7 37 162 37C 168.3 37 173.7 18 180 18" pathFrom="M -1 80L -1 80L 18 80L 36 80L 54 80L 72 80L 90 80L 108 80L 126 80L 144 80L 162 80L 180 80"></path>
                                                            <g id="SvgjsG1950" class="apexcharts-series-markers-wrap" data:realIndex="0"></g>
                                                        </g>
                                                        <g id="SvgjsG1953" class="apexcharts-series" seriesName="seriesx2" data:longestSeries="true" rel="2" data:realIndex="1">
                                                            <path id="SvgjsPath1956" d="M 0 60C 6.3 60 11.7 70 18 70C 24.3 70 29.7 50 36 50C 42.3 50 47.7 65 54 65C 60.3 65 65.7 57 72 57C 78.3 57 83.7 80 90 80C 96.3 80 101.7 55 108 55C 114.3 55 119.7 65 126 65C 132.3 65 137.7 60 144 60C 150.3 60 155.7 75 162 75C 168.3 75 173.7 53 180 53" fill="none" fill-opacity="1" stroke="rgba(220,218,227,0.85)" stroke-opacity="1" stroke-linecap="butt" stroke-width="1" stroke-dasharray="5" class="apexcharts-line" index="1" clip-path="url(#gridRectMaskvr6m1p7zh)" pathTo="M 0 60C 6.3 60 11.7 70 18 70C 24.3 70 29.7 50 36 50C 42.3 50 47.7 65 54 65C 60.3 65 65.7 57 72 57C 78.3 57 83.7 80 90 80C 96.3 80 101.7 55 108 55C 114.3 55 119.7 65 126 65C 132.3 65 137.7 60 144 60C 150.3 60 155.7 75 162 75C 168.3 75 173.7 53 180 53" pathFrom="M -1 80L -1 80L 18 80L 36 80L 54 80L 72 80L 90 80L 108 80L 126 80L 144 80L 162 80L 180 80"></path>
                                                            <g id="SvgjsG1954" class="apexcharts-series-markers-wrap" data:realIndex="1"></g>
                                                        </g>
                                                        <g id="SvgjsG1951" class="apexcharts-datalabels" data:realIndex="0"></g>
                                                        <g id="SvgjsG1955" class="apexcharts-datalabels" data:realIndex="1"></g>
                                                    </g>
                                                    <line id="SvgjsLine1970" x1="0" y1="0" x2="180" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                    <line id="SvgjsLine1971" x1="0" y1="0" x2="180" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    <g id="SvgjsG1972" class="apexcharts-yaxis-annotations"></g>
                                                    <g id="SvgjsG1973" class="apexcharts-xaxis-annotations"></g>
                                                    <g id="SvgjsG1974" class="apexcharts-point-annotations"></g>
                                                </g>
                                                <rect id="SvgjsRect1944" width="0" height="0" x="0" y="0" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fefefe"></rect>
                                                <g id="SvgjsG1959" class="apexcharts-yaxis" rel="0" transform="translate(-18, 0)"></g>
                                                <g id="SvgjsG1942" class="apexcharts-annotations"></g>
                                            </svg>
                                            <div class="apexcharts-legend" style="max-height: 40px;"></div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary waves-effect waves-float waves-light">Increase Budget</button>
                                    <div class="resize-triggers">
                                        <div class="expand-trigger">
                                            <div style="width: 265px; height: 346px;"></div>
                                        </div>
                                        <div class="contract-trigger"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Revenue Report Card -->
                </div>

                <div class="row match-height">
                    <!-- Company Table Card -->
                    <div class="col-lg-8 col-12">
                        <div class="card card-company-table">
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Company</th>
                                                <th>Category</th>
                                                <th>Views</th>
                                                <th>Revenue</th>
                                                <th>Sales</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/toolbox.svg') }}" alt="Toolbar svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Dixons</div>
                                                            <div class="font-small-2 text-muted">meguc@ruj.io</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-primary me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-monitor font-medium-3">
                                                                    <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                                                    <line x1="8" y1="21" x2="16" y2="21"></line>
                                                                    <line x1="12" y1="17" x2="12" y2="21"></line>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Technology</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">23.4k</span>
                                                        <span class="font-small-2 text-muted">in 24 hours</span>
                                                    </div>
                                                </td>
                                                <td>$891.2</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">68%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-down text-danger font-medium-1">
                                                            <polyline points="23 18 13.5 8.5 8.5 13.5 1 6"></polyline>
                                                            <polyline points="17 18 23 18 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/parachute.svg') }}" alt="Parachute svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Motels</div>
                                                            <div class="font-small-2 text-muted">vecav@hodzi.co.uk</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-success me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-coffee font-medium-3">
                                                                    <path d="M18 8h1a4 4 0 0 1 0 8h-1"></path>
                                                                    <path d="M2 8h16v9a4 4 0 0 1-4 4H6a4 4 0 0 1-4-4V8z"></path>
                                                                    <line x1="6" y1="1" x2="6" y2="4"></line>
                                                                    <line x1="10" y1="1" x2="10" y2="4"></line>
                                                                    <line x1="14" y1="1" x2="14" y2="4"></line>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Grocery</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">78k</span>
                                                        <span class="font-small-2 text-muted">in 2 days</span>
                                                    </div>
                                                </td>
                                                <td>$668.51</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">97%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up text-success font-medium-1">
                                                            <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                            <polyline points="17 6 23 6 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/brush.svg') }}" alt="Brush svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Zipcar</div>
                                                            <div class="font-small-2 text-muted">davcilse@is.gov</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-warning me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-watch font-medium-3">
                                                                    <circle cx="12" cy="12" r="7"></circle>
                                                                    <polyline points="12 9 12 12 13.5 13.5"></polyline>
                                                                    <path d="M16.51 17.35l-.35 3.83a2 2 0 0 1-2 1.82H9.83a2 2 0 0 1-2-1.82l-.35-3.83m.01-10.7l.35-3.83A2 2 0 0 1 9.83 1h4.35a2 2 0 0 1 2 1.82l.35 3.83"></path>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Fashion</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">162</span>
                                                        <span class="font-small-2 text-muted">in 5 days</span>
                                                    </div>
                                                </td>
                                                <td>$522.29</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">62%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up text-success font-medium-1">
                                                            <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                            <polyline points="17 6 23 6 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/star.svg') }}" alt="Star svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Owning</div>
                                                            <div class="font-small-2 text-muted">us@cuhil.gov</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-primary me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-monitor font-medium-3">
                                                                    <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                                                                    <line x1="8" y1="21" x2="16" y2="21"></line>
                                                                    <line x1="12" y1="17" x2="12" y2="21"></line>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Technology</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">214</span>
                                                        <span class="font-small-2 text-muted">in 24 hours</span>
                                                    </div>
                                                </td>
                                                <td>$291.01</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">88%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up text-success font-medium-1">
                                                            <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                            <polyline points="17 6 23 6 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/book.svg') }}" alt="Book svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Cafés</div>
                                                            <div class="font-small-2 text-muted">pudais@jife.com</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-success me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-coffee font-medium-3">
                                                                    <path d="M18 8h1a4 4 0 0 1 0 8h-1"></path>
                                                                    <path d="M2 8h16v9a4 4 0 0 1-4 4H6a4 4 0 0 1-4-4V8z"></path>
                                                                    <line x1="6" y1="1" x2="6" y2="4"></line>
                                                                    <line x1="10" y1="1" x2="10" y2="4"></line>
                                                                    <line x1="14" y1="1" x2="14" y2="4"></line>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Grocery</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">208</span>
                                                        <span class="font-small-2 text-muted">in 1 week</span>
                                                    </div>
                                                </td>
                                                <td>$783.93</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">16%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-down text-danger font-medium-1">
                                                            <polyline points="23 18 13.5 8.5 8.5 13.5 1 6"></polyline>
                                                            <polyline points="17 18 23 18 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/rocket.svg') }}" alt="Rocket svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Kmart</div>
                                                            <div class="font-small-2 text-muted">bipri@cawiw.com</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-warning me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-watch font-medium-3">
                                                                    <circle cx="12" cy="12" r="7"></circle>
                                                                    <polyline points="12 9 12 12 13.5 13.5"></polyline>
                                                                    <path d="M16.51 17.35l-.35 3.83a2 2 0 0 1-2 1.82H9.83a2 2 0 0 1-2-1.82l-.35-3.83m.01-10.7l.35-3.83A2 2 0 0 1 9.83 1h4.35a2 2 0 0 1 2 1.82l.35 3.83"></path>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Fashion</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">990</span>
                                                        <span class="font-small-2 text-muted">in 1 month</span>
                                                    </div>
                                                </td>
                                                <td>$780.05</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">78%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up text-success font-medium-1">
                                                            <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                            <polyline points="17 6 23 6 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar rounded">
                                                            <div class="avatar-content">
                                                                <img src="{{ asset('app-assets/images/icons/speaker.svg') }}" alt="Speaker svg">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="fw-bolder">Payers</div>
                                                            <div class="font-small-2 text-muted">luk@izug.io</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar bg-light-warning me-1">
                                                            <div class="avatar-content">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-watch font-medium-3">
                                                                    <circle cx="12" cy="12" r="7"></circle>
                                                                    <polyline points="12 9 12 12 13.5 13.5"></polyline>
                                                                    <path d="M16.51 17.35l-.35 3.83a2 2 0 0 1-2 1.82H9.83a2 2 0 0 1-2-1.82l-.35-3.83m.01-10.7l.35-3.83A2 2 0 0 1 9.83 1h4.35a2 2 0 0 1 2 1.82l.35 3.83"></path>
                                                                </svg>
                                                            </div>
                                                        </div>
                                                        <span>Fashion</span>
                                                    </div>
                                                </td>
                                                <td class="text-nowrap">
                                                    <div class="d-flex flex-column">
                                                        <span class="fw-bolder mb-25">12.9k</span>
                                                        <span class="font-small-2 text-muted">in 12 hours</span>
                                                    </div>
                                                </td>
                                                <td>$531.49</td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="fw-bolder me-1">42%</span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up text-success font-medium-1">
                                                            <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                            <polyline points="17 6 23 6 23 12"></polyline>
                                                        </svg>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Company Table Card -->

                    <!-- Developer Meetup Card -->
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card card-developer-meetup">
                            <div class="meetup-img-wrapper rounded-top text-center">
                                <img src="{{ asset('app-assets/images/illustration/email.svg') }}" alt="Meeting Pic" height="170">
                            </div>
                            <div class="card-body">
                                <div class="meetup-header d-flex align-items-center">
                                    <div class="meetup-day">
                                        <h6 class="mb-0">THU</h6>
                                        <h3 class="mb-0">24</h3>
                                    </div>
                                    <div class="my-auto">
                                        <h4 class="card-title mb-25">Developer Meetup</h4>
                                        <p class="card-text mb-0">Meet world popular developers</p>
                                    </div>
                                </div>
                                <div class="mt-0">
                                    <div class="avatar float-start bg-light-primary rounded me-1">
                                        <div class="avatar-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-calendar avatar-icon font-medium-3">
                                                <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                                <line x1="16" y1="2" x2="16" y2="6"></line>
                                                <line x1="8" y1="2" x2="8" y2="6"></line>
                                                <line x1="3" y1="10" x2="21" y2="10"></line>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="more-info">
                                        <h6 class="mb-0">Sat, May 25, 2020</h6>
                                        <small>10:AM to 6:PM</small>
                                    </div>
                                </div>
                                <div class="mt-2">
                                    <div class="avatar float-start bg-light-primary rounded me-1">
                                        <div class="avatar-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-map-pin avatar-icon font-medium-3">
                                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                                                <circle cx="12" cy="10" r="3"></circle>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="more-info">
                                        <h6 class="mb-0">Central Park</h6>
                                        <small>Manhattan, New york City</small>
                                    </div>
                                </div>
                                <div class="avatar-group">
                                    <div data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="bottom" title="" class="avatar pull-up" data-bs-original-title="Billy Hopkins">
                                        <img src="{{ asset('app-assets/images/portrait/small/avatar-s-9.jpg') }}" alt="Avatar" width="33" height="33">
                                    </div>
                                    <div data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="bottom" title="" class="avatar pull-up" data-bs-original-title="Amy Carson">
                                        <img src="{{ asset('app-assets/images/portrait/small/avatar-s-6.jpg') }}" alt="Avatar" width="33" height="33">
                                    </div>
                                    <div data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="bottom" title="" class="avatar pull-up" data-bs-original-title="Brandon Miles">
                                        <img src="{{ asset('app-assets/images/portrait/small/avatar-s-8.jpg') }}" alt="Avatar" width="33" height="33">
                                    </div>
                                    <div data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="bottom" title="" class="avatar pull-up" data-bs-original-title="Daisy Weber">
                                        <img src="{{ asset('app-assets/images/portrait/small/avatar-s-20.jpg') }}" alt="Avatar" width="33" height="33">
                                    </div>
                                    <div data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="bottom" title="" class="avatar pull-up" data-bs-original-title="Jenny Looper">
                                        <img src="{{ asset('app-assets/images/portrait/small/avatar-s-20.jpg') }}" alt="Avatar" width="33" height="33">
                                    </div>
                                    <h6 class="align-self-center cursor-pointer ms-50 mb-0">+42</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Developer Meetup Card -->

                    <!-- Browser States Card -->
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card card-browser-states">
                            <div class="card-header">
                                <div>
                                    <h4 class="card-title">Browser States</h4>
                                    <p class="card-text font-small-2">Counter August 2020</p>
                                </div>
                                <div class="dropdown chart-dropdown">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-more-vertical font-medium-3 cursor-pointer" data-bs-toggle="dropdown">
                                        <circle cx="12" cy="12" r="1"></circle>
                                        <circle cx="12" cy="5" r="1"></circle>
                                        <circle cx="12" cy="19" r="1"></circle>
                                    </svg>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#">Last 28 Days</a>
                                        <a class="dropdown-item" href="#">Last Month</a>
                                        <a class="dropdown-item" href="#">Last Year</a>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="browser-states">
                                    <div class="d-flex">
                                        <img src="{{ asset('app-assets/images/icons/google-chrome.png') }}" class="rounded me-1" height="30" alt="Google Chrome">
                                        <h6 class="align-self-center mb-0">Google Chrome</h6>
                                    </div>
                                    <div class="d-flex align-items-center" style="position: relative;">
                                        <div class="fw-bold text-body-heading me-1">54.4%</div>
                                        <div id="browser-state-chart-primary" style="min-height: 35.7px;">
                                            <div id="apexcharts4zknmky1" class="apexcharts-canvas apexcharts4zknmky1 apexcharts-theme-light" style="width: 30px; height: 35.7px;"><svg id="SvgjsSvg1648" width="30" height="35.699999999999996" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1650" class="apexcharts-inner apexcharts-graphical" transform="translate(-15, -12)">
                                                        <defs id="SvgjsDefs1649">
                                                            <clipPath id="gridRectMask4zknmky1">
                                                                <rect id="SvgjsRect1652" width="66" height="59" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMask4zknmky1">
                                                                <rect id="SvgjsRect1653" width="64" height="61" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <g id="SvgjsG1654" class="apexcharts-radialbar">
                                                            <g id="SvgjsG1655">
                                                                <g id="SvgjsG1656" class="apexcharts-tracks">
                                                                    <g id="SvgjsG1657" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                        <path id="apexcharts-radialbarTrack-0" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703" fill="none" fill-opacity="1" stroke="rgba(235,235,235,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.952395121951219" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703"></path>
                                                                    </g>
                                                                </g>
                                                                <g id="SvgjsG1659">
                                                                    <g id="SvgjsG1662" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                        <path id="SvgjsPath1663" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 26.649258182615842 41.68542541152726" fill="none" fill-opacity="0.85" stroke="rgba(115,103,240,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="4.074634146341463" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="196" data:value="54.4" index="0" j="0" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 26.649258182615842 41.68542541152726"></path>
                                                                    </g>
                                                                    <circle id="SvgjsCircle1660" r="5.180143902439028" cx="30" cy="30" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                                    <g id="SvgjsG1661" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"></g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <line id="SvgjsLine1664" x1="0" y1="0" x2="60" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1665" x1="0" y1="0" x2="60" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    </g>
                                                    <g id="SvgjsG1651" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend"></div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 87px; height: 37px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="browser-states">
                                    <div class="d-flex">
                                        <img src="{{ asset('app-assets/images/icons/mozila-firefox.png') }}" class="rounded me-1" height="30" alt="Mozila Firefox">
                                        <h6 class="align-self-center mb-0">Mozila Firefox</h6>
                                    </div>
                                    <div class="d-flex align-items-center" style="position: relative;">
                                        <div class="fw-bold text-body-heading me-1">6.1%</div>
                                        <div id="browser-state-chart-warning" style="min-height: 35.7px;">
                                            <div id="apexchartswa151gq7l" class="apexcharts-canvas apexchartswa151gq7l apexcharts-theme-light" style="width: 30px; height: 35.7px;"><svg id="SvgjsSvg1666" width="30" height="35.699999999999996" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1668" class="apexcharts-inner apexcharts-graphical" transform="translate(-15, -12)">
                                                        <defs id="SvgjsDefs1667">
                                                            <clipPath id="gridRectMaskwa151gq7l">
                                                                <rect id="SvgjsRect1670" width="66" height="59" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMaskwa151gq7l">
                                                                <rect id="SvgjsRect1671" width="64" height="61" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <g id="SvgjsG1672" class="apexcharts-radialbar">
                                                            <g id="SvgjsG1673">
                                                                <g id="SvgjsG1674" class="apexcharts-tracks">
                                                                    <g id="SvgjsG1675" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                        <path id="apexcharts-radialbarTrack-0" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703" fill="none" fill-opacity="1" stroke="rgba(235,235,235,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.952395121951219" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703"></path>
                                                                    </g>
                                                                </g>
                                                                <g id="SvgjsG1677">
                                                                    <g id="SvgjsG1680" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                        <path id="SvgjsPath1681" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 34.55384566401036 18.728836464521155" fill="none" fill-opacity="0.85" stroke="rgba(255,159,67,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="4.074634146341463" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="22" data:value="6.1" index="0" j="0" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 34.55384566401036 18.728836464521155"></path>
                                                                    </g>
                                                                    <circle id="SvgjsCircle1678" r="5.180143902439028" cx="30" cy="30" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                                    <g id="SvgjsG1679" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"></g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <line id="SvgjsLine1682" x1="0" y1="0" x2="60" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1683" x1="0" y1="0" x2="60" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    </g>
                                                    <g id="SvgjsG1669" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend"></div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 74px; height: 37px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="browser-states">
                                    <div class="d-flex">
                                        <img src="{{ asset('app-assets/images/icons/apple-safari.png') }}" class="rounded me-1" height="30" alt="Apple Safari">
                                        <h6 class="align-self-center mb-0">Apple Safari</h6>
                                    </div>
                                    <div class="d-flex align-items-center" style="position: relative;">
                                        <div class="fw-bold text-body-heading me-1">14.6%</div>
                                        <div id="browser-state-chart-secondary" style="min-height: 35.7px;">
                                            <div id="apexchartsv2upsmcy" class="apexcharts-canvas apexchartsv2upsmcy apexcharts-theme-light" style="width: 30px; height: 35.7px;"><svg id="SvgjsSvg1684" width="30" height="35.699999999999996" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1686" class="apexcharts-inner apexcharts-graphical" transform="translate(-15, -12)">
                                                        <defs id="SvgjsDefs1685">
                                                            <clipPath id="gridRectMaskv2upsmcy">
                                                                <rect id="SvgjsRect1688" width="66" height="59" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMaskv2upsmcy">
                                                                <rect id="SvgjsRect1689" width="64" height="61" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <g id="SvgjsG1690" class="apexcharts-radialbar">
                                                            <g id="SvgjsG1691">
                                                                <g id="SvgjsG1692" class="apexcharts-tracks">
                                                                    <g id="SvgjsG1693" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                        <path id="apexcharts-radialbarTrack-0" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703" fill="none" fill-opacity="1" stroke="rgba(235,235,235,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.952395121951219" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703"></path>
                                                                    </g>
                                                                </g>
                                                                <g id="SvgjsG1695">
                                                                    <g id="SvgjsG1698" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                        <path id="SvgjsPath1699" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 39.70848596494321 22.684131080750916" fill="none" fill-opacity="0.85" stroke="rgba(130,134,139,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="4.074634146341463" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="53" data:value="14.6" index="0" j="0" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 39.70848596494321 22.684131080750916"></path>
                                                                    </g>
                                                                    <circle id="SvgjsCircle1696" r="5.180143902439028" cx="30" cy="30" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                                    <g id="SvgjsG1697" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"></g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <line id="SvgjsLine1700" x1="0" y1="0" x2="60" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1701" x1="0" y1="0" x2="60" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    </g>
                                                    <g id="SvgjsG1687" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend"></div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 84px; height: 37px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="browser-states">
                                    <div class="d-flex">
                                        <img src="{{ asset('app-assets/images/icons/internet-explorer.png') }}" class="rounded me-1" height="30" alt="Internet Explorer">
                                        <h6 class="align-self-center mb-0">Internet Explorer</h6>
                                    </div>
                                    <div class="d-flex align-items-center" style="position: relative;">
                                        <div class="fw-bold text-body-heading me-1">4.2%</div>
                                        <div id="browser-state-chart-info" style="min-height: 35.7px;">
                                            <div id="apexcharts3jpmphjuk" class="apexcharts-canvas apexcharts3jpmphjuk apexcharts-theme-light" style="width: 30px; height: 35.7px;"><svg id="SvgjsSvg1702" width="30" height="35.699999999999996" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1704" class="apexcharts-inner apexcharts-graphical" transform="translate(-15, -12)">
                                                        <defs id="SvgjsDefs1703">
                                                            <clipPath id="gridRectMask3jpmphjuk">
                                                                <rect id="SvgjsRect1706" width="66" height="59" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMask3jpmphjuk">
                                                                <rect id="SvgjsRect1707" width="64" height="61" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <g id="SvgjsG1708" class="apexcharts-radialbar">
                                                            <g id="SvgjsG1709">
                                                                <g id="SvgjsG1710" class="apexcharts-tracks">
                                                                    <g id="SvgjsG1711" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                        <path id="apexcharts-radialbarTrack-0" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703" fill="none" fill-opacity="1" stroke="rgba(235,235,235,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.952395121951219" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703"></path>
                                                                    </g>
                                                                </g>
                                                                <g id="SvgjsG1713">
                                                                    <g id="SvgjsG1716" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                        <path id="SvgjsPath1717" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 33.14629268950116 18.257875827299152" fill="none" fill-opacity="0.85" stroke="rgba(0,207,232,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="4.074634146341463" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="15" data:value="4.2" index="0" j="0" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 33.14629268950116 18.257875827299152"></path>
                                                                    </g>
                                                                    <circle id="SvgjsCircle1714" r="5.180143902439028" cx="30" cy="30" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                                    <g id="SvgjsG1715" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"></g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <line id="SvgjsLine1718" x1="0" y1="0" x2="60" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1719" x1="0" y1="0" x2="60" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    </g>
                                                    <g id="SvgjsG1705" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend"></div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 79px; height: 37px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="browser-states">
                                    <div class="d-flex">
                                        <img src="{{ asset('app-assets/images/icons/opera.png') }}" class="rounded me-1" height="30" alt="Opera Mini">
                                        <h6 class="align-self-center mb-0">Opera Mini</h6>
                                    </div>
                                    <div class="d-flex align-items-center" style="position: relative;">
                                        <div class="fw-bold text-body-heading me-1">8.4%</div>
                                        <div id="browser-state-chart-danger" style="min-height: 35.7px;">
                                            <div id="apexchartsbkb8tden" class="apexcharts-canvas apexchartsbkb8tden apexcharts-theme-light" style="width: 30px; height: 35.7px;"><svg id="SvgjsSvg1720" width="30" height="35.699999999999996" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                                    <g id="SvgjsG1722" class="apexcharts-inner apexcharts-graphical" transform="translate(-15, -12)">
                                                        <defs id="SvgjsDefs1721">
                                                            <clipPath id="gridRectMaskbkb8tden">
                                                                <rect id="SvgjsRect1724" width="66" height="59" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                            <clipPath id="gridRectMarkerMaskbkb8tden">
                                                                <rect id="SvgjsRect1725" width="64" height="61" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                            </clipPath>
                                                        </defs>
                                                        <g id="SvgjsG1726" class="apexcharts-radialbar">
                                                            <g id="SvgjsG1727">
                                                                <g id="SvgjsG1728" class="apexcharts-tracks">
                                                                    <g id="SvgjsG1729" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                        <path id="apexcharts-radialbarTrack-0" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703" fill="none" fill-opacity="1" stroke="rgba(235,235,235,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.952395121951219" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 1 1 29.997878318175438 17.84365872173703"></path>
                                                                    </g>
                                                                </g>
                                                                <g id="SvgjsG1731">
                                                                    <g id="SvgjsG1734" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                        <path id="SvgjsPath1735" d="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 36.07817073170732 19.472299475604824" fill="none" fill-opacity="0.85" stroke="rgba(234,84,85,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="4.074634146341463" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="30" data:value="8.4" index="0" j="0" data:pathOrig="M 30 17.843658536585362 A 12.156341463414638 12.156341463414638 0 0 1 36.07817073170732 19.472299475604824"></path>
                                                                    </g>
                                                                    <circle id="SvgjsCircle1732" r="5.180143902439028" cx="30" cy="30" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                                    <g id="SvgjsG1733" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"></g>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <line id="SvgjsLine1736" x1="0" y1="0" x2="60" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                        <line id="SvgjsLine1737" x1="0" y1="0" x2="60" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                                    </g>
                                                    <g id="SvgjsG1723" class="apexcharts-annotations"></g>
                                                </svg>
                                                <div class="apexcharts-legend"></div>
                                            </div>
                                        </div>
                                        <div class="resize-triggers">
                                            <div class="expand-trigger">
                                                <div style="width: 79px; height: 37px;"></div>
                                            </div>
                                            <div class="contract-trigger"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Browser States Card -->

                    <!-- Goal Overview Card -->
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title">Goal Overview</h4>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-help-circle font-medium-3 text-muted cursor-pointer">
                                    <circle cx="12" cy="12" r="10"></circle>
                                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                                    <line x1="12" y1="17" x2="12.01" y2="17"></line>
                                </svg>
                            </div>
                            <div class="card-body p-0" style="position: relative;">
                                <div id="goal-overview-radial-bar-chart" class="my-2" style="min-height: 205.633px;">
                                    <div id="apexchartseoojyl1o" class="apexcharts-canvas apexchartseoojyl1o apexcharts-theme-light" style="width: 380px; height: 205.633px;"><svg id="SvgjsSvg2064" width="380" height="205.63333333333335" xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)" style="background: transparent;">
                                            <g id="SvgjsG2066" class="apexcharts-inner apexcharts-graphical" transform="translate(67.5, -10)">
                                                <defs id="SvgjsDefs2065">
                                                    <clipPath id="gridRectMaskeoojyl1o">
                                                        <rect id="SvgjsRect2068" width="251" height="217" x="-3" y="-1" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                    </clipPath>
                                                    <clipPath id="gridRectMarkerMaskeoojyl1o">
                                                        <rect id="SvgjsRect2069" width="249" height="219" x="-2" y="-2" rx="0" ry="0" opacity="1" stroke-width="0" stroke="none" stroke-dasharray="0" fill="#fff"></rect>
                                                    </clipPath>
                                                    <linearGradient id="SvgjsLinearGradient2074" x1="0" y1="1" x2="1" y2="1">
                                                        <stop id="SvgjsStop2075" stop-opacity="1" stop-color="rgba(40,199,111,1)" offset="0"></stop>
                                                        <stop id="SvgjsStop2076" stop-opacity="1" stop-color="rgba(235,233,241,1)" offset="1"></stop>
                                                        <stop id="SvgjsStop2077" stop-opacity="1" stop-color="rgba(235,233,241,1)" offset="1"></stop>
                                                    </linearGradient>
                                                    <linearGradient id="SvgjsLinearGradient2084" x1="0" y1="1" x2="1" y2="1">
                                                        <stop id="SvgjsStop2085" stop-opacity="1" stop-color="rgba(40,199,111,1)" offset="0"></stop>
                                                        <stop id="SvgjsStop2086" stop-opacity="1" stop-color="rgba(81,229,168,1)" offset="1"></stop>
                                                        <stop id="SvgjsStop2087" stop-opacity="1" stop-color="rgba(81,229,168,1)" offset="1"></stop>
                                                    </linearGradient>
                                                    <filter id="SvgjsFilter2089" filterUnits="userSpaceOnUse" width="200%" height="200%" x="-50%" y="-50%">
                                                        <feFlood id="SvgjsFeFlood2090" flood-color="#000000" flood-opacity="0.1" result="SvgjsFeFlood2090Out" in="SourceGraphic"></feFlood>
                                                        <feComposite id="SvgjsFeComposite2091" in="SvgjsFeFlood2090Out" in2="SourceAlpha" operator="in" result="SvgjsFeComposite2091Out"></feComposite>
                                                        <feOffset id="SvgjsFeOffset2092" dx="1" dy="1" result="SvgjsFeOffset2092Out" in="SvgjsFeComposite2091Out"></feOffset>
                                                        <feGaussianBlur id="SvgjsFeGaussianBlur2093" stdDeviation="3 " result="SvgjsFeGaussianBlur2093Out" in="SvgjsFeOffset2092Out"></feGaussianBlur>
                                                        <feMerge id="SvgjsFeMerge2094" result="SvgjsFeMerge2094Out" in="SourceGraphic">
                                                            <feMergeNode id="SvgjsFeMergeNode2095" in="SvgjsFeGaussianBlur2093Out"></feMergeNode>
                                                            <feMergeNode id="SvgjsFeMergeNode2096" in="[object Arguments]"></feMergeNode>
                                                        </feMerge>
                                                        <feBlend id="SvgjsFeBlend2097" in="SourceGraphic" in2="SvgjsFeMerge2094Out" mode="normal" result="SvgjsFeBlend2097Out"></feBlend>
                                                    </filter>
                                                </defs>
                                                <g id="SvgjsG2070" class="apexcharts-radialbar">
                                                    <g id="SvgjsG2071">
                                                        <g id="SvgjsG2072" class="apexcharts-tracks">
                                                            <g id="SvgjsG2073" class="apexcharts-radialbar-track apexcharts-track" rel="1">
                                                                <path id="apexcharts-radialbarTrack-0" d="M 77.85670731707313 184.82445114399718 A 89.28658536585367 89.28658536585367 0 1 1 167.14329268292684 184.82445114399718" fill="none" fill-opacity="1" stroke="rgba(235,233,241,0.85)" stroke-opacity="1" stroke-linecap="round" stroke-width="3.5304878048780495" stroke-dasharray="0" class="apexcharts-radialbar-area" data:pathOrig="M 77.85670731707313 184.82445114399718 A 89.28658536585367 89.28658536585367 0 1 1 167.14329268292684 184.82445114399718"></path>
                                                            </g>
                                                        </g>
                                                        <g id="SvgjsG2079">
                                                            <g id="SvgjsG2083" class="apexcharts-series apexcharts-radial-series" seriesName="seriesx1" rel="1" data:realIndex="0">
                                                                <path id="SvgjsPath2088" d="M 77.85670731707313 184.82445114399718 A 89.28658536585367 89.28658536585367 0 1 1 210.6873193374061 121.46749921697622" fill="none" fill-opacity="0.85" stroke="url(#SvgjsLinearGradient2084)" stroke-opacity="1" stroke-linecap="round" stroke-width="7.060975609756099" stroke-dasharray="0" class="apexcharts-radialbar-area apexcharts-radialbar-slice-0" data:angle="249" data:value="83" filter="url(#SvgjsFilter2089)" index="0" j="0" data:pathOrig="M 77.85670731707313 184.82445114399718 A 89.28658536585367 89.28658536585367 0 1 1 210.6873193374061 121.46749921697622"></path>
                                                            </g>
                                                            <circle id="SvgjsCircle2080" r="82.52134146341464" cx="122.5" cy="107.5" class="apexcharts-radialbar-hollow" fill="transparent"></circle>
                                                            <g id="SvgjsG2081" class="apexcharts-datalabels-group" transform="translate(0, 0) scale(1)" style="opacity: 1;"><text id="SvgjsText2082" font-family="Helvetica, Arial, sans-serif" x="122.5" y="123.5" text-anchor="middle" dominant-baseline="auto" font-size="2.86rem" font-weight="600" fill="#5e5873" class="apexcharts-text apexcharts-datalabel-value" style="font-family: Helvetica, Arial, sans-serif;">83%</text></g>
                                                        </g>
                                                    </g>
                                                </g>
                                                <line id="SvgjsLine2098" x1="0" y1="0" x2="245" y2="0" stroke="#b6b6b6" stroke-dasharray="0" stroke-width="1" class="apexcharts-ycrosshairs"></line>
                                                <line id="SvgjsLine2099" x1="0" y1="0" x2="245" y2="0" stroke-dasharray="0" stroke-width="0" class="apexcharts-ycrosshairs-hidden"></line>
                                            </g>
                                            <g id="SvgjsG2067" class="apexcharts-annotations"></g>
                                        </svg>
                                        <div class="apexcharts-legend"></div>
                                    </div>
                                </div>
                                <div class="row border-top text-center mx-0">
                                    <div class="col-6 border-end py-1">
                                        <p class="card-text text-muted mb-0">Completed</p>
                                        <h3 class="fw-bolder mb-0">786,617</h3>
                                    </div>
                                    <div class="col-6 py-1">
                                        <p class="card-text text-muted mb-0">In Progress</p>
                                        <h3 class="fw-bolder mb-0">13,561</h3>
                                    </div>
                                </div>
                                <div class="resize-triggers">
                                    <div class="expand-trigger">
                                        <div style="width: 381px; height: 324px;"></div>
                                    </div>
                                    <div class="contract-trigger"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Goal Overview Card -->

                    <!-- Transaction Card -->
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="card card-transaction">
                            <div class="card-header">
                                <h4 class="card-title">Transactions</h4>
                                <div class="dropdown chart-dropdown">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-more-vertical font-medium-3 cursor-pointer" data-bs-toggle="dropdown">
                                        <circle cx="12" cy="12" r="1"></circle>
                                        <circle cx="12" cy="5" r="1"></circle>
                                        <circle cx="12" cy="19" r="1"></circle>
                                    </svg>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#">Last 28 Days</a>
                                        <a class="dropdown-item" href="#">Last Month</a>
                                        <a class="dropdown-item" href="#">Last Year</a>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="transaction-item">
                                    <div class="d-flex">
                                        <div class="avatar bg-light-primary rounded float-start">
                                            <div class="avatar-content">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-pocket avatar-icon font-medium-3">
                                                    <path d="M4 3h16a2 2 0 0 1 2 2v6a10 10 0 0 1-10 10A10 10 0 0 1 2 11V5a2 2 0 0 1 2-2z"></path>
                                                    <polyline points="8 10 12 14 16 10"></polyline>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="transaction-percentage">
                                            <h6 class="transaction-title">Wallet</h6>
                                            <small>Starbucks</small>
                                        </div>
                                    </div>
                                    <div class="fw-bolder text-danger">- $74</div>
                                </div>
                                <div class="transaction-item">
                                    <div class="d-flex">
                                        <div class="avatar bg-light-success rounded float-start">
                                            <div class="avatar-content">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check avatar-icon font-medium-3">
                                                    <polyline points="20 6 9 17 4 12"></polyline>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="transaction-percentage">
                                            <h6 class="transaction-title">Bank Transfer</h6>
                                            <small>Add Money</small>
                                        </div>
                                    </div>
                                    <div class="fw-bolder text-success">+ $480</div>
                                </div>
                                <div class="transaction-item">
                                    <div class="d-flex">
                                        <div class="avatar bg-light-danger rounded float-start">
                                            <div class="avatar-content">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-dollar-sign avatar-icon font-medium-3">
                                                    <line x1="12" y1="1" x2="12" y2="23"></line>
                                                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="transaction-percentage">
                                            <h6 class="transaction-title">Paypal</h6>
                                            <small>Add Money</small>
                                        </div>
                                    </div>
                                    <div class="fw-bolder text-success">+ $590</div>
                                </div>
                                <div class="transaction-item">
                                    <div class="d-flex">
                                        <div class="avatar bg-light-warning rounded float-start">
                                            <div class="avatar-content">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-credit-card avatar-icon font-medium-3">
                                                    <rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect>
                                                    <line x1="1" y1="10" x2="23" y2="10"></line>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="transaction-percentage">
                                            <h6 class="transaction-title">Mastercard</h6>
                                            <small>Ordered Food</small>
                                        </div>
                                    </div>
                                    <div class="fw-bolder text-danger">- $23</div>
                                </div>
                                <div class="transaction-item">
                                    <div class="d-flex">
                                        <div class="avatar bg-light-info rounded float-start">
                                            <div class="avatar-content">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up avatar-icon font-medium-3">
                                                    <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
                                                    <polyline points="17 6 23 6 23 12"></polyline>
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="transaction-percentage">
                                            <h6 class="transaction-title">Transfer</h6>
                                            <small>Refund</small>
                                        </div>
                                    </div>
                                    <div class="fw-bolder text-success">+ $98</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/ Transaction Card -->
                </div>
            </section>
            <!-- Dashboard Ecommerce ends -->
        </div>
    </div>
</div>
@include('admin_layout.footer')
<script src="{{ asset('app-assets/js/scripts/pages/dashboard-ecommerce.js') }}"></script>
<script src="{{ asset('app-assets/vendors/js/charts/apexcharts.min.js') }}"></script>
@endsection