@extends('layout.pageheader')
@section('title', 'My Account')
@section('content')
<div class="mad-breadcrumb with-bg-image" data-bg-image-src="{{ asset('assets_front/images/header.webp') }}" style="background-image: url(&quot;assets_front/images/1920x392_bg1.jpg&quot;);">
  <div class="container">
    <h1 class="mad-page-title">My Account</h1>
    <nav class="mad-breadcrumb-path"><span><a href="{{url('/')}}">Home</a></span> / <span>My Account</span>
    </nav>
  </div>
</div>
<div class="mad-content no-pd">
  <div class="container">
    <div class="mad-section">
      <h2 style="text-align: center;">Create an Account</h2>
      <div class="content-element-15">
        <div class="row vr-size-5">

          <div class="col-lg-6">

            <div class="content-element-15">
              <h3>Login</h3>
              <hr>
              <form class="mad-contact-form type-2 var2" id="frmLogin">
                @csrf
                <div class="mad-col">
                  <label>Userid</label>
                  <input type="tel" placeholder="Userid" autocomplete="nope" name="str_login_name" onKeyPress="return isNumberKey(event)" required>
                  <span class="mad-text-small mad-text-color-3" id="login_msg"> </span>
                </div>

                <div class="mad-col">
                  <label>Password</label>
                  <input type="password" placeholder="Password" autocomplete="nope" name="str_login_password" required>
                  <span class="mad-text-small mad-text-color-3" id="login_msg"> </span>
                </div>


                <button class="btn btn-big btn-style-3 aa-browse-btn" type="submit" id="btnLogin">Login</button>
                <!-- <label for="rememberme" class="rememberme"><input type="checkbox" id="rememberme" name="rememberme"> Remember me </label> -->

              </form>
            </div>

          </div>

          <div class="col-lg-6">

            <div class="content-element-15">
              <h3>Create New Account</h3>
              <hr>
              <form class="mad-contact-form type-2 var2" id="regcust">
                @csrf
                <div class="mad-col">
                  <label>Userid</label>
                  <input type="tel" placeholder="Userid" class="@error('name') is-invalid @enderror" autocomplete="nope" name="name" onKeyPress="return isNumberKey(event)">
                  <div id="name_error" class="field_error"></div>
                  @error('name')
                  <span class="invalid-feedback mad-text-small mad-text-color-3" id="name_error" role="alert">
                    <strong>{{ $message }}</strong>
                  </span>
                  @enderror
                </div>
                <div class="mad-col">
                  <label>Email</label>
                  <input type="email" placeholder="Email" class="@error('email') is-invalid @enderror" autocomplete="nope" name="email">
                  <div id="email_error" class="field_error"></div>
                  @error('email')
                  <span class="invalid-feedback mad-text-small mad-text-color-3" id="email_error" role="alert">
                    <strong>{{ $message }}</strong>
                  </span>
                  @enderror
                </div>
                <div class="mad-col">
                  <label>Password</label>
                  <input type="password" placeholder="Password" class="@error('password') is-invalid @enderror" autocomplete="current-password" name="password" id="password">
                  <div id="password_error" class="field_error"></div>
                  @error('password')
                  <span class="invalid-feedback mad-text-small mad-text-color-3" id="password_error" role="alert">
                    <strong>The password used to access your account. <br>{{ $message }}</strong>
                  </span>
                  @enderror
                </div>
                <div class="mad-col">
                  <label>Password Again<br></label>
                  <input type="password" placeholder="Confirm password" class="@error('password') is-invalid @enderror" autocomplete="current-password" name="password_confirmation" id="password">
                  <div id="password_confirmation_error" class="field_error"></div>
                
                </div>
                <button type="submit" class="btn btn-big btn-style-3" id="regcustsmt">Register</button>
              </form>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('script')
<script>
  function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if (charCode != 46 && charCode > 31 &&
      (charCode < 48 || charCode > 57))
      return false;

    return true;
  }

</script>
@endsection