@extends('layout.pageheader')
@section('title', 'Shop')
@section('style')

@endsection
@section('content')
<div class="mad-breadcrumb with-bg-image" data-bg-image-src="{{ asset('assets_front/images/header.webp') }}" style="background-image: url(&quot;assets_front/images/1920x392_bg1.jpg&quot;);">
    <div class="container">
        <h1 class="mad-page-title">Shop</h1>
        <nav class="mad-breadcrumb-path"><span><a href="{{url('/')}}">Home</a></span> / <span>Shop</span>
        </nav>
    </div>
</div>
<!-- popup -->

<!-- closw -->

<div class="mad-content">
    <div class="container">
        <div class="content-element-17">
            <!--================ Team Members ================-->
            <div class="row vr-size-2">
                <div class="col-xl-9">
                    <h2 class="mad-page-title">Shop</h2>
                    <!--================ Tabs ================-->
                    <div class="mad-tabs mad-tabs--tour-sections">
                        <!--================ Tabs Navigation ================-->
                        <div role="tablist" aria-label="Tour Sections v1" class="mad-tabs-nav">
                            <!-- <span class="mad-active"><a id="" href="" role="tab" aria-selected="true" aria-controls="" class="mad-tab-link">All</a>
              </span> -->
                            @foreach($category as $home_categories)
                            <span class="{{ $home_categories->id == 1 ? 'mad-active' : '' }}"><a id="tab-{{$home_categories->id}}-link" href="#tab-{{$home_categories->id}}" role="tab" aria-selected="false" aria-controls="tab-{{$home_categories->id}}" class="mad-tab-link">{{$home_categories->category}}</a>
                            </span> @endforeach
                        </div>
                        <!--================ End of Tabs Navigation ================-->
                        <!--================ Tabs Container ================-->
                        <div class="mad-tabs-container">
                            <!--================ Tab ================-->
                            @foreach($category as $home_categories)
                            <div id="tab-{{$home_categories->id}}" tabindex="0" role="tabpanel" aria-labelledby="tab-{{$home_categories->id}}-link" class="mad-tab">
                                @foreach($home_categories->products as $list)
                                <div class="mad-col">
                                    <!-- Specification item -->
                                    <div class="mad-spec-item">
                                        <img src="{{asset('storage/media/'.$list->image)}}" alt="" style=" height: 60px; width: 80px; margin-right: 20px; border-radius: 15px; ">
                                        <div class="mad-spec-info">
                                            <div class="mad-spec-header">
                                                <div class="mad-spec-title">{{$list->name}}</div>
                                                <div class="mad-line"></div>
                                                <div class="mad-spec-price">{{$list->product_price}}</div>
                                            </div>
                                            <div class="mad-spec-tags">
                                                <div class="mad-spec-el">{{$list->short_desc}}</div>
                                                <a href="{{url('product')}}/{{$list->slug}}" style=" padding: 6.2px; font-size: 12px; " class="btn">Add To Cart</a>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End of Specification item -->
                                </div>
                                @endforeach
                            </div>
                            @endforeach
                            <!--================ End of Tab ================-->
                        </div>
                        <!--================ End of Tabs Container ================-->
                    </div>
                    <!--================ End of Tabs ================-->
                </div>
                @php
                $getAddToCartTotalItem=getAddToCartTotalItem();
                $totalCartItem=count($getAddToCartTotalItem);
                $totalPrice=0;
                @endphp

                <aside id="sidebar" class="mad-sidebar col-xl-3">
                    <div class="mad-widget">
                        <div class="shopping-cart">
                            <h5 class="mad-widget-title">Cart</h5>
                            <div class="mad-products mad-product-small">
                                @if($totalCartItem>0)
                                @foreach($cartdatas as $cartItem)

                                <div class="mad-col">
                                    <!-- Product -->
                                    <div class="mad-product">
                                        <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                                        <a href="#" class="mad-product-image">
                                            <img src="{{ asset('assets_front/images/72x72_img1.jpg') }}" alt="">
                                        </a>
                                        <!-- product-info -->
                                        <div class="mad-product-description">
                                            <h6 class="mad-product-title"><a href="#" class="mad-link">{{$cartItem->product_name}}</a></h6>
                                            <span class="mad-product-price">{{$cartItem->pqty}} * $ {{$cartItem->total_price/$cartItem->pqty}}</span>
                                        </div>
                                        <!--/ product-info -->
                                    </div>
                                    <!-- End of Product -->
                                </div>
                                @endforeach
                            </div>
                            <div class="sc-footer">
                                <div class="subtotal">Subtotal: <span class="mad-price">{{$cartdatas->sum('total_price')}}</span></div>
                                <a href="{{url('checkout')}}" class="btn btn-small btn-style-3 w-100"><i class="material-icons">arrow_right_alt</i><span>Checkout</span></a>
                            </div>
                            @endif
                        </div>
                    </div>
                </aside>
            </div>
            <!--================ End Of Team Members ================-->
        </div>
    </div>
</div>
@endsection
@section('script')

@endsection