<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('welcome', function () {
    return view('welcome');
});

// Route::get('/', function () {
//     return view('front/home');
// });
Route::get('about', function () {
    return view('front/about');
});
Route::get('track', function () {
    return view('front/track');
});
Route::get('contact', function () {
    return view('front/contect');
});
Route::get('myaccount', function () {
    return view('front/myaccount');
});
// Route::get('thankyou', function () {
//     return view('front/thankyou');
// });
// Route::get('checkout', function () {
//     return view('front/checkout');
// });

Route::get('/', [App\Http\Controllers\HomeController::class, 'index']);

Route::get('product/{id}', [App\Http\Controllers\Controller::class, 'product']);
Route::get('shop', [App\Http\Controllers\Controller::class, 'shop']);
Route::post('/add_to_cart', [App\Http\Controllers\Controller::class, 'add_to_cart']);

Route::get('checkout', [App\Http\Controllers\CheckoutController::class, 'index']);
Route::get('checkout/delete/{id}', [App\Http\Controllers\CheckoutController::class, 'delete']);
Route::post('/ordercomplete', [App\Http\Controllers\CheckoutController::class, 'ordercomplete']);

Route::get('thankyou', [App\Http\Controllers\OrderdoneController::class, 'index']);

Route::get('menu', [App\Http\Controllers\ProductController::class, 'menu']);

Route::get('register', [App\Http\Controllers\Controller::class, 'register']);
Route::post('register_customer', [App\Http\Controllers\Controller::class, 'register_customer']);
Route::post('login_process', [App\Http\Controllers\Controller::class, 'login_process']);

Route::get('logout', function () {
    session()->forget('FRONT_USER_LOGIN');
    session()->forget('FRONT_USER_ID');
    session()->forget('FRONT_USER_NAME');
    session()->forget('USER_TEMP_ID');
    return redirect('/');
});
// Auth::routes();

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');


Route::group(['middleware' => 'admin_auth'], function () {

    Route::get('dashbord', [App\Http\Controllers\AdminController::class, 'dashbord']);
    Route::get('category', [App\Http\Controllers\CategoryController::class, 'index']);
    Route::post('category_add', [App\Http\Controllers\CategoryController::class, 'create']);
    Route::get('admin/delete/{id}', [App\Http\Controllers\CategoryController::class, 'delete']);
    Route::get('category/{id}', [App\Http\Controllers\CategoryController::class, 'index']);
    Route::get('category/status/{status}/{id}', [App\Http\Controllers\CategoryController::class, 'status']);

    Route::get('admin/coupon', [App\Http\Controllers\CouponController::class, 'index']);
    Route::post('admin/coupon_add', [App\Http\Controllers\CouponController::class, 'create']);
    Route::get('admin/coupon/delete/{id}', [App\Http\Controllers\CouponController::class, 'delete']);
    Route::get('admin/coupon/{id}', [App\Http\Controllers\CouponController::class, 'index']);
    Route::get('admin/coupon/status/{status}/{id}', [App\Http\Controllers\CouponController::class, 'status']);

    Route::get('admin/size', [App\Http\Controllers\SizeController::class, 'index']);
    Route::post('admin/size_add', [App\Http\Controllers\SizeController::class, 'create']);
    Route::get('admin/size/delete/{id}', [App\Http\Controllers\SizeController::class, 'delete']);
    Route::get('admin/size/{id}', [App\Http\Controllers\SizeController::class, 'index']);
    Route::get('admin/size/status/{status}/{id}', [App\Http\Controllers\SizeController::class, 'status']);

    Route::get('admin/toppings', [App\Http\Controllers\ToppingsController::class, 'index']);
    Route::post('admin/toppings_add', [App\Http\Controllers\ToppingsController::class, 'create']);
    Route::get('admin/toppings/delete/{id}', [App\Http\Controllers\ToppingsController::class, 'delete']);
    Route::get('admin/toppings/{id}', [App\Http\Controllers\ToppingsController::class, 'index']);
    Route::get('admin/toppings/status/{status}/{id}', [App\Http\Controllers\ToppingsController::class, 'status']);

    Route::get('admin/pretoppings', [App\Http\Controllers\PretoppingController::class, 'index']);
    Route::post('admin/pretoppings_add', [App\Http\Controllers\PretoppingController::class, 'create']);
    Route::get('admin/pretoppings/delete/{id}', [App\Http\Controllers\PretoppingController::class, 'delete']);
    Route::get('admin/pretoppings/{id}', [App\Http\Controllers\PretoppingController::class, 'index']);
    Route::get('admin/pretoppings/status/{status}/{id}', [App\Http\Controllers\PretoppingController::class, 'status']);

    Route::get('admin/sauce', [App\Http\Controllers\SaucesController::class, 'index']);
    Route::post('admin/sauce_add', [App\Http\Controllers\SaucesController::class, 'create']);
    Route::get('admin/sauce/delete/{id}', [App\Http\Controllers\SaucesController::class, 'delete']);
    Route::get('admin/sauce/{id}', [App\Http\Controllers\SaucesController::class, 'index']);
    Route::get('admin/sauce/status/{status}/{id}', [App\Http\Controllers\SaucesController::class, 'status']);

    Route::get('admin/crust', [App\Http\Controllers\CrustsController::class, 'index']);
    Route::post('admin/crust_add', [App\Http\Controllers\CrustsController::class, 'create']);
    Route::get('admin/crust/delete/{id}', [App\Http\Controllers\CrustsController::class, 'delete']);
    Route::get('admin/crust/{id}', [App\Http\Controllers\CrustsController::class, 'index']);
    Route::get('admin/crust/status/{status}/{id}', [App\Http\Controllers\CrustsController::class, 'status']);

    Route::get('admin/cooking', [App\Http\Controllers\CookingController::class, 'index']);
    Route::post('admin/cooking_add', [App\Http\Controllers\CookingController::class, 'create']);
    Route::get('admin/cooking/delete/{id}', [App\Http\Controllers\CookingController::class, 'delete']);
    Route::get('admin/cooking/{id}', [App\Http\Controllers\CookingController::class, 'index']);
    Route::get('admin/cooking/status/{status}/{id}', [App\Http\Controllers\CookingController::class, 'status']);

    Route::get('admin/wings', [App\Http\Controllers\WingsController::class, 'index']);
    Route::post('admin/wings_add', [App\Http\Controllers\WingsController::class, 'create']);
    Route::get('admin/wings/delete/{id}', [App\Http\Controllers\WingsController::class, 'delete']);
    Route::get('admin/wings/{id}', [App\Http\Controllers\WingsController::class, 'index']);
    Route::get('admin/wings/status/{status}/{id}', [App\Http\Controllers\WingsController::class, 'status']);

    Route::get('admin/dipping', [App\Http\Controllers\DippingsController::class, 'index']);
    Route::post('admin/dipping_add', [App\Http\Controllers\DippingsController::class, 'create']);
    Route::get('admin/dipping/delete/{id}', [App\Http\Controllers\DippingsController::class, 'delete']);
    Route::get('admin/dipping/{id}', [App\Http\Controllers\DippingsController::class, 'index']);
    Route::get('admin/dipping/status/{status}/{id}', [App\Http\Controllers\DippingsController::class, 'status']);


    Route::get('admin/product', [App\Http\Controllers\ProductController::class, 'index_add']);
    Route::get('admin/product_insert', [App\Http\Controllers\ProductController::class, 'index']);
    Route::post('admin/product_add', [App\Http\Controllers\ProductController::class, 'create']);
    Route::get('admin/product/delete/{id}', [App\Http\Controllers\ProductController::class, 'delete']);
    Route::get('admin/product_insert/{id}', [App\Http\Controllers\ProductController::class, 'index']);
    Route::get('admin/product/status/{status}/{id}', [App\Http\Controllers\ProductController::class, 'status']);

    Route::get('admin/order', [App\Http\Controllers\CheckoutController::class, 'order_data_for_admin']);
    Route::get('admin/order_detail/{id}', [App\Http\Controllers\CheckoutController::class, 'order_detail']);
});

Route::get('admin', [App\Http\Controllers\AdminController::class, 'admin']);
Route::post('admin/auth', [App\Http\Controllers\AdminController::class, 'auth']);
// Route::get('admin/updatepassword', [App\Http\Controllers\AdminController::class, 'updatepassword']);
Route::get('admin/logout', function () {
    session()->forget('ADMIN_LOGIN');
    session()->forget('ADMIN_ID');
    session()->flash('error', 'Logout sucessfully');
    return redirect('admin');
});
