<?php

namespace App\Http\Controllers;

use App\Models\crusts;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class CrustsController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = crusts::where(['id' => $id])->get();

            $result['crust'] = $arr['0']->crust;
            $result['crust_price'] = $arr['0']->crust_price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['crust'] = '';
            $result['crust_price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $crusts = crusts::all();
        return view('admin/crust', compact('crusts'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "crust" => 'required|unique:crusts,crust,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $crusts=crusts::find($request->input('id'));
            $msg="Crust updated";
        }else{
            $crusts = new crusts;
            $msg="Crust inserted";
        }
        $crusts->crust = $request->input('crust');
        $crusts->crust_price = $request->input('crust_price');
        $crusts->status=1;
        $crusts->save();
        Session::flash('message', $msg);
        return redirect('admin/crust');
    }


    public function store(Request $request)
    {
    }

    public function show(crusts $crusts)
    {
    }

    public function edit(crusts $crusts)
    {
    }

    public function status(Request $request,$status,$id){
        $model=crusts::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Crust status updated');
        return redirect('admin/crust');
    }

    public function delete(Request $request, $id)
    {
        $model = crusts::find($id);
        $model->delete();
        Session::flash('message', 'Crust deleted');
        return redirect('admin/crust');
    }
}
