<?php

namespace App\Http\Controllers;

use App\Models\dippings;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class DippingsController extends Controller
{
    public function index(Request $request, $id = '')
    {
        if ($id > 0) {
            $arr = dippings::where(['id' => $id])->get();

            $result['dipping'] = $arr['0']->dipping;
            $result['dipping_price'] = $arr['0']->dipping_price;
            $result['status'] = $arr['0']->status;
            $result['id']=$arr['0']->id;
        } else {
            $result['dipping'] = '';
            $result['dipping_price'] = '';
            $result['status'] = '';
            $result['id']=0;
        }
        $dippings = dippings::all();
        return view('admin/dippings', compact('dippings'),$result);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            "dipping" => 'required|unique:dippings,dipping,'.$request->input('id'),

        ]);
        if($request->input('id')>0){
            $dippings=dippings::find($request->input('id'));
            $msg="Dipping updated";
        }else{
            $dippings = new dippings;
            $msg="Dipping inserted";
        }
        $dippings->dipping = $request->input('dipping');
        $dippings->dipping_price = $request->input('dipping_price');
        $dippings->status=1;
        $dippings->save();
        Session::flash('message', $msg);
        return redirect('admin/dipping');
    }


    public function store(Request $request)
    {
    }

    public function show(dippings $dippings)
    {
    }

    public function edit(dippings $dippings)
    {
    }

    public function status(Request $request,$status,$id){
        $model=dippings::find($id);
        $model->status=$status;
        $model->save();
        Session::flash('message','Dipping status updated');
        return redirect('admin/dipping');
    }

    public function delete(Request $request, $id)
    {
        $model = dippings::find($id);
        $model->delete();
        Session::flash('message', 'Dipping deleted');
        return redirect('admin/dipping');
    }
}
