<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\custregister;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;

class customerController extends Controller
{
    public function register(Request $request)
    {

        if ($request->session()->has('FRONT_USER_LOGIN') != null) {
            return redirect('/');
        }

        $result = [];
        return view('front.register', $result);
    }

    public function register_customer(Request $request)
    {
        $valid = Validator::make($request->all(), [
            "name" => 'required',
            "email" => 'required|email|unique:custregisters,email',
            "password" => 'required|string|min:8|confirmed',
        ]);

        if ($valid->fails()) {
            return response()->json(['statuss' => 'error', 'error' => $valid->errors()->toArray()]);
        } else {
            $arr = [
                "name" => $request->name,
                "email" => $request->email,
                "password" => Crypt::encrypt($request->password),
                "status" => 1,
                "created_at" => date('Y-m-d h:i:s'),
                "updated_at" => date('Y-m-d h:i:s')
            ];
            $query = DB::table('custregisters')->insert($arr);
            if ($query) {
                return response()->json(['statuss' => 'success', 'msg' => "Registration successfully"]);
            }
        }
    }

    // login Process

    public function login_process(Request $request)
    {

        $result = DB::table('custregisters')
            ->where(['name' => $request->str_login_name])
            ->get();

        if (isset($result[0])) {
            $db_pwd = Crypt::decrypt($result[0]->password);
            $status = $result[0]->status;
            // $is_verify=$result[0]->is_verify;

            // if($is_verify==0){
            //     return response()->json(['status'=>"error",'msg'=>'Please verify your Username']); 
            // }
            // if($status==0){
            //     return response()->json(['status'=>"error",'msg'=>'Your account has been deactivated']); 
            // }

            if ($db_pwd == $request->str_login_password) {

                if ($request->rememberme === null) {
                    setcookie('login_name', $request->str_login_name, 100);
                    setcookie('login_pwd', $request->str_login_password, 100);
                } else {
                    setcookie('login_name', $request->str_login_name, time() + 60 * 60 * 24 * 100);
                    setcookie('login_pwd', $request->str_login_password, time() + 60 * 60 * 24 * 100);
                }

                $request->session()->put('FRONT_USER_LOGIN', true);
                $request->session()->put('FRONT_USER_ID', $result[0]->id);
                $request->session()->put('FRONT_USER_NAME', $result[0]->name);
                $status = "success";
                $msg = "";

                // $getUserTempId=getUserTempId();
                // DB::table('cart')  
                //     ->where(['user_id'=>$getUserTempId,'user_type'=>'Not-Reg'])
                //     ->update(['user_id'=>$result[0]->id,'user_type'=>'Reg']);

            } else {
                $status = "error";
                $msg = "Please enter valid password";
            }
        } else {
            $status = "error";
            $msg = "Please enter valid Username";
        }
        return response()->json(['status' => $status, 'msg' => $msg]);
        //$request->password
    }
}
