<!DOCTYPE html>
<html lang="en">

<head>
  <!--================ Basic page needs ================-->
  <title> <?php echo $__env->yieldContent('title'); ?> </title>
  <meta charset="UTF-8">
  <meta name="author" content="">
  <meta name="keywords" content="">
  <meta name="description" content="">
  <!--================ Mobile specific metas ================-->
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!--================ Favicon ================-->
  <link rel="shortcut icon" href="<?php echo e(asset('assets_front/images/favicon.ico')); ?>">
  <!--================ Google web fonts ================-->
  <link href="https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&family=Lato:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Material+Icons%7CMaterial+Icons+Outlined%7CMaterial+Icons+Two+Tone%7CMaterial+Icons+Round%7CMaterial+Icons+Sharp" rel="stylesheet">
  <!--================ Vendor CSS ================-->
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/fontawesome-all.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/linearicons.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/vendors/owl-carousel/assets/owl.carousel.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/vendors/arcticmodal/jquery.arcticmodal-0.3.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/bootstrap.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/animate.min.css')); ?>">
  <!-- REVOLUTION STYLE SHEETS -->
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets_front/css/settings.css')); ?>">
  <!--================ Theme CSS ================-->
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/style.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/responsive.css')); ?>">

  <!--================ Vendor JS ================-->
  <?php echo $__env->yieldContent('style'); ?>
</head>

<body>

  <div id="mad-page-wrapper" class="mad-page-wrapper">

    <!--================ Header ================-->
    <header id="mad-header" class="mad-header">
      <div class="mad-pre-header">
        <div class="mad-our-info">
          <div class="mad-info"><i class="material-icons-outlined">location_on</i> <span>144 Lake Street
              St. Catharines, Ontario L2R 5Y3</span></div>
          <!-- <div class="mad-info"><i class="material-icons">access_time</i> <span>Mon - Fri: 8am - 11pm, Sat - Sun: 8am -
              12pm</span></div> -->
        </div>
        <div class="mad-quick-links">
          <?php if(session()->has('FRONT_USER_LOGIN')!=null): ?>
          <a href="<?php echo e(url('logout')); ?>">Logout</a>
          <?php else: ?>
          <a href="<?php echo e(url('register')); ?>">Login/Register</a>
          <?php endif; ?>
        </div>
      </div>
      <div class="mad-header-section--sticky-xl">
        <div class="mad-header-items">
          <div class="mad-header-item">
            <a href="<?php echo e(url('/')); ?>" class="mad-logo"><img src="<?php echo e(asset('assets_front/images/dlogo.png')); ?>" alt=""></a>
          </div>
          <!--================ Navigation ================-->
          <nav class="mad-navigation-container">
            <ul class="mad-navigation mad-navigation--vertical-sm">
              <li class="<?php echo e(request()->is('/') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
              <li class="<?php echo e(request()->is('about') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('about')); ?>">About Us</a></li>
              <li class="<?php echo e(request()->is('menu') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('menu')); ?>">Menu</a></li>
              <li class="<?php echo e(request()->is('contact') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('contact')); ?>">Contact Us</a></li>

            </ul>
          </nav>
          <!--================ End of Navigation ================-->
          <div class="mad-header-item">
            <div class="mad-our-info type-2">
              <div class="mad-info">
                <i class="material-icons-outlined">call</i>
                <div class="mad-info-content">
                  <span>Call us for ordering</span>
                  <div class="mad-info-title">(905) 685-4111</div>
                </div>
              </div>
            </div>
          </div>
          <div class="mad-header-item">
            <div class="mad-actions">
              <div class="mad-item">
                <!-- <a href="#" class="mad-item-link" data-arctic-modal="#search-modal"><i
                    class="material-icons">search</i></a> -->
                <?php
                $getAddToCartTotalItem=getAddToCartTotalItem();
                $totalCartItem=count($getAddToCartTotalItem);
                $totalPrice=0;
                ?>
                <a href="<?php echo e(url('myaccount')); ?>" class="mad-item-link"><i class="material-icons">person_outline</i></a>
                <div class="mad-dropdown">
                  <a href="#" type="button" class="mad-item-link mad-dropdown-title"><i class="material-icons-outlined">shopping_cart</i><span class="quantity"><?php echo e($totalCartItem); ?></span></a>
                  <div class="shopping-cart mad-dropdown-element">
                    <div class="mad-products mad-product-small">
                      <?php if($totalCartItem>0): ?>
                      <?php $__currentLoopData = $getAddToCartTotalItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="mad-col">
                        <?php
                        $totalPrice=$totalPrice+($cartItem->pqty*$cartItem->product_price)
                        ?>
                        <!-- Product -->
                        <div class="mad-product">
                          <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                          <a href="#" class="mad-product-image">
                            <img src="<?php echo e(asset('assets_front/images/72x72_img1.jpg')); ?>" alt="">
                          </a>
                          <!-- product-info -->
                          <div class="mad-product-description">
                            <h6 class="mad-product-title"><a href="#" class="mad-link"><?php echo e($cartItem->product_name); ?></a></h6>
                            <span class="mad-product-price"><?php echo e($cartItem->pqty); ?> * $ <?php echo e($cartItem->product_price); ?></span>
                          </div>
                          <!--/ product-info -->
                        </div>
                        <!-- End of Product -->
                      </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="sc-footer">
                      <div class="subtotal">Subtotal: <span class="mad-price"><?php echo e($totalPrice); ?></span></div>
                      <a href="<?php echo e(url('checkout')); ?>" class="btn btn-small btn-style-3 w-100"><i class="material-icons">arrow_right_alt</i><span>Checkout</span></a>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              

              <div class="mad-item">
                <a href="<?php echo e(url('shop')); ?>" class="btn btn-small"><span>Order Online</span></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
    <!--================ End of Header ================-->

    <?php echo $__env->yieldContent('content'); ?>


    <!--================ Footer ================-->
    <footer id="mad-footer" class="mad-footer">
      <!--================ Footer row ================-->
      <div class="mad-footer-main">
        <div class="container">
          <div class="row vr-size-1">
            <div class="col-lg-6">
              <!--================ Widget ================-->
              <section class="mad-widget">
                <div class="content-element-5">
                  <a href="<?php echo e(url('/')); ?>" class="mad-logo"><img src="<?php echo e(asset('assets_front/images/dlogo.png')); ?>" alt="" style="width: 170px;"></a>
                </div>
                <div class="mad-our-info vr-type">
                  <div class="mad-info"><i class="material-icons-outlined">location_on</i> <span>144 Lake Street
                      St. Catharines, Ontario L2R 5Y3 <br> <a href="#" class="mad-link mad-dir">Get Directions</a></span></div>
                  <div class="mad-info"><i class="material-icons-outlined">call</i> <span>(905) 685-4111</span></div>
                  <div class="mad-info"><i class="material-icons">mail_outline</i> <a href="#" class="mad-link">mail@companyname.com</a></div>
                  <div class="mad-info"><i class="material-icons">access_time</i> <span>Monday: Closed,
                      Sunday: 2pm–10pm,</br> Tue-Wed: 4pm–11pm , Thur: 3pm–11pm , Fri- Sat: 2pm–12am</span></div>
                </div>
              </section>
              <!--================ End of Widget ================-->
            </div>
            <div class="col-lg-2">
              <!--================ Widget ================-->
              <section class="mad-widget">
                <h5 class="mad-widget-title">Menu</h5>
                <div class="mad-vr-list">
                  <ul>
                    <li><a href="#" class="mad-link">Regular Pizza</a></li>
                    <li><a href="#" class="mad-link">Wings</a></li>
                    <li><a href="#" class="mad-link">Combos</a></li>
                    <li><a href="#" class="mad-link">House Specialty</a></li>
                    <li><a href="#" class="mad-link">Pazarotti</a></li>
                    <li><a href="#" class="mad-link">Specialty Subs</a></li>
                  </ul>
                </div>
              </section>
              <!--================ End of Widget ================-->
            </div>
            <div class="col-lg-2">
              <!--================ Widget ================-->
              <section class="mad-widget">
                <h5 class="mad-widget-title">Company</h5>
                <div class="mad-vr-list">
                  <ul>
                    <li><a href="#" class="mad-link">About</a></li>
                    <li><a href="#" class="mad-link">The Menu</a></li>
                    <li><a href="#" class="mad-link">Testimonials</a></li>
                    <li><a href="#" class="mad-link">Blog</a></li>
                    <li><a href="#" class="mad-link">Shop</a></li>
                    <li><a href="#" class="mad-link">Gift Cards</a></li>
                  </ul>
                </div>
              </section>
              <!--================ End of Widget ================-->
            </div>
            <div class="col-lg-2">
              <!--================ Widget ================-->
              <section class="mad-widget">
                <h5 class="mad-widget-title">Support</h5>
                <div class="mad-vr-list">
                  <ul>
                    <li><a href="#" class="mad-link">How to Order</a></li>
                    <li><a href="#" class="mad-link">Where We Deliver</a></li>
                    <li><a href="#" class="mad-link">FAQs</a></li>
                    <li><a href="#" class="mad-link">Contact</a></li>
                    <li><a href="#" class="mad-link">Terms and Contiotions</a></li>
                    <li><a href="#" class="mad-link">Privacy Policy</a></li>
                  </ul>
                </div>
              </section>
              <!--================ End of Widget ================-->
            </div>
          </div>
        </div>
      </div>
      <!--================ End of Footer row ================-->
      <div class="mad-footer-bottom">
        <div class="container">
          <p class="copyrights">Copyright © 2021 Yummi.
            All Rights Reserved.</p>
          <div class="mad-social-icons">
            <ul>
              <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
              <li><a href="#"><i class="fab fa-twitter"></i></a></li>
              <li><a href="#"><i class="fab fa-instagram"></i></a></li>
              <li><a href="#"><i class="fab fa-tripadvisor"></i></a></li>
              <li><a href="#"><i class="fab fa-youtube"></i></a></li>
              <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
            </ul>
          </div>
        </div>
      </div>
    </footer>
    <!--================ End of Footer ================-->
  </div>
  <script src="<?php echo e(asset('assets_front/vendors/modernizr.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/jquery-3.3.1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/jquery.easing.1.3.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/jquery.parallax-1.1.3.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/monkeysan.jquery.nav.1.0.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/monkeysan.validator.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/handlebars-v4.0.5.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/arcticmodal/jquery.arcticmodal-0.3.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/retina.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/monkeysan.tabs.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>
  <!-- SLIDER REVOLUTION 5.0 EXTENSIONS  (Load Extensions only on Local File Systems !  The following part can be removed on Server for On Demand Loading) -->
  <script src="<?php echo e(asset('assets_front/vendors/revolution/js/extensions/revolution.extension.layeranimation.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/vendors/revolution/js/extensions/revolution.extension.slideanims.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/js/modules/mad.alert-box.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/js/modules/mad.newsletter-form.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/js/modules/mad.sticky-header-section.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/js/mad.app.js')); ?>"></script>
  <script src="<?php echo e(asset('assets_front/js/custome.js')); ?>"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>

  <?php echo $__env->yieldContent('script'); ?>

</body>

</html><?php /**PATH D:\Xampp\htdocs\pizzafront\resources\views\layout\pageheader.blade.php ENDPATH**/ ?>