<!DOCTYPE html>
<html lang="en">

<head>
    <!--================ Basic page needs ================-->
    <title>Shop</title>
    <meta charset="UTF-8">
    <meta name="author" content="">
    <meta name="keywords" content="">
    <meta name="description" content="">
    <!--================ Mobile specific metas ================-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!--================ Google web fonts ================-->
    <link href="https://fonts.googleapis.com/css2?family=Josefin+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&family=Lato:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&display=swap" rel="stylesheet">
    <!--================ Vendor CSS ================-->
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/fontawesome-all.min.css')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Material+Icons%7CMaterial+Icons+Outlined%7CMaterial+Icons+Two+Tone%7CMaterial+Icons+Round%7CMaterial+Icons+Sharp" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/linearicons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/vendors/owl-carousel/assets/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/vendors/arcticmodal/jquery.arcticmodal-0.3.css')); ?>">
    <!--================ Theme CSS ================-->
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets_front/css/responsive.css')); ?>">
    <!--================ Vendor JS ================-->
</head>

<body>

    <div id="mad-page-wrapper" class="mad-page-wrapper">
        <!--================ Search Modal ================-->

        <!--================ End of Search Modal ================-->
        <!--================ Header ================-->
        <header id="mad-header" class="mad-header">
      <div class="mad-pre-header">
        <div class="mad-our-info">
          <div class="mad-info"><i class="material-icons-outlined">location_on</i> <span>144 Lake Street
              St. Catharines, Ontario L2R 5Y3</span></div>
          <!-- <div class="mad-info"><i class="material-icons">access_time</i> <span>Mon - Fri: 8am - 11pm, Sat - Sun: 8am -
              12pm</span></div> -->
        </div>
        <div class="mad-quick-links">
          <?php if(session()->has('FRONT_USER_LOGIN')!=null): ?>
          <a href="<?php echo e(url('logout')); ?>">Logout</a>
          <?php else: ?>
          <a href="<?php echo e(url('register')); ?>">Login/Register</a>
          <?php endif; ?>
        </div>
      </div>
      <div class="mad-header-section--sticky-xl">
        <div class="mad-header-items">
          <div class="mad-header-item">
            <a href="<?php echo e(url('/')); ?>" class="mad-logo"><img src="<?php echo e(asset('assets_front/images/dlogo.png')); ?>" alt=""></a>
          </div>
          <!--================ Navigation ================-->
          <nav class="mad-navigation-container">
            <ul class="mad-navigation mad-navigation--vertical-sm">
              <li class="<?php echo e(request()->is('/') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
              <li class="<?php echo e(request()->is('about') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('about')); ?>">About Us</a></li>
              <li class="<?php echo e(request()->is('menu') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('menu')); ?>">Menu</a></li>
              <li class="<?php echo e(request()->is('contact') ? 'current-menu-item' : ''); ?> menu-item"><a href="<?php echo e(url('contact')); ?>">Contact Us</a></li>

            </ul>
          </nav>
          <!--================ End of Navigation ================-->
          <div class="mad-header-item">
            <div class="mad-our-info type-2">
              <div class="mad-info">
                <i class="material-icons-outlined">call</i>
                <div class="mad-info-content">
                  <span>Call us for ordering</span>
                  <div class="mad-info-title">(905) 685-4111</div>
                </div>
              </div>
            </div>
          </div>
          <div class="mad-header-item">
            <div class="mad-actions">
              <div class="mad-item">
                <!-- <a href="#" class="mad-item-link" data-arctic-modal="#search-modal"><i
                    class="material-icons">search</i></a> -->
                <?php
                $getAddToCartTotalItem=getAddToCartTotalItem();
                $totalCartItem=count($getAddToCartTotalItem);
                $totalPrice=0;
                ?>
                <a href="<?php echo e(url('myaccount')); ?>" class="mad-item-link"><i class="material-icons">person_outline</i></a>
                <div class="mad-dropdown">
                  <a href="#" type="button" class="mad-item-link mad-dropdown-title"><i class="material-icons-outlined">shopping_cart</i><span class="quantity"><?php echo e($totalCartItem); ?></span></a>
                  <div class="shopping-cart mad-dropdown-element">
                    <div class="mad-products mad-product-small">
                      <?php if($totalCartItem>0): ?>
                      <div class="mad-col">
                        <?php $__currentLoopData = $getAddToCartTotalItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php
                        $totalPrice=$totalPrice+($cartItem->pqty*$cartItem->product_price)
                        ?>
                        <!-- Product -->
                        <div class="mad-product">
                          <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                          <a href="#" class="mad-product-image">
                            <img src="<?php echo e(asset('assets_front/images/72x72_img1.jpg')); ?>" alt="">
                          </a>
                          <!-- product-info -->
                          <div class="mad-product-description">
                            <h6 class="mad-product-title"><a href="#" class="mad-link"><?php echo e($cartItem->product_name); ?></a></h6>
                            <span class="mad-product-price"><?php echo e($cartItem->pqty); ?> * $ <?php echo e($cartItem->product_price); ?></span>
                          </div>
                          <!--/ product-info -->
                        </div>
                        <!-- End of Product -->
                      </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      
                    </div>
                    <div class="sc-footer">
                      <div class="subtotal">Subtotal: <span class="mad-price"><?php echo e($totalPrice); ?></span></div>
                      <a href="<?php echo e(url('checkout')); ?>" class="btn btn-small btn-style-3 w-100"><i class="material-icons">arrow_right_alt</i><span>Checkout</span></a>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div class="mad-item">
                <a href="<?php echo e(url('shop')); ?>" class="btn btn-small"><span>Order Online</span></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
        <!--================ End of Header ================-->
              <!--================ Breadcrumb ================-->
      <div class="mad-breadcrumb with-bg-image" data-bg-image-src="<?php echo e(asset('assets_front/images/1920x392_bg1.jpg')); ?>">
        <div class="container">
          <h1 class="mad-page-title">Shop Pizza</h1>
          <nav class="mad-breadcrumb-path"><span><a href="<?php echo e(url('/')); ?>">Home</a></span> / <span>Shop</span>
          </nav>
        </div>
      </div>
      <!--================ End of Breadcrumb ================-->
        <div class="mad-content">
            <div class="container">
                <div class="row hr-size-2 vr-size-2">
                    <main id="main" class="col-xl-9">
                        <!-- Product sorting -->
                        <div class="product-sort-section">
                            <div class="mad-col">
                                <!--================ Filter ================-->
                                <nav class="mad-filter-wrap">
                                    <ul id="portfolio-filter" class="mad-filter justify-content-center">

                                        <li><a href="#" data-filter="*" class="mad-active">All</a></li>
                                        <?php $__currentLoopData = $home_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $home_categories): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="#" data-filter=".mad-category-<?php echo e($home_categories->id); ?>"><?php echo e($home_categories->category); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </ul>
                                </nav>
                                <!--================ End of Filter ================-->
                            </div>
                            <!-- <div class="mad-col">
                                <div id="toggle-item" class="toggle-item">
                                    <button id="toggle-btn" class="btn btn-small btn-style-1"><i class="material-icons">tune</i><span>More
                                            Filters</span></button>
                                    <div class="toggle-section lg-right-side">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <h5 class="mad-page-title">Filter by Price</h5>
                                                <div class="mad-range-slider-field">
                                                    <div class="mad-range-slider ui-slider ui-corner-all ui-slider-horizontal ui-widget ui-widget-content">
                                                        <div class="ui-slider-range ui-corner-all ui-widget-header" style="left: 10.0503%; width: 39.6985%;"></div><span tabindex="0" class="ui-slider-handle ui-corner-all ui-state-default" style="left: 10.0503%;"></span><span tabindex="0" class="ui-slider-handle ui-corner-all ui-state-default" style="left: 49.7487%;"></span>
                                                    </div>
                                                    <input type="text" value="Price: $1,000 - $99,000" name="check_availability_price" readonly="" class="mad-range-slider-input">
                                                    <a href="#" class="btn btn-mini btn-style-1">Filter</a>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <h5 class="mad-page-title">Food Type</h5>
                                                <div id="mad-filter-list" class="mad-filter-list">
                                                    <ul>
                                                        <li>
                                                            <span>
                                                                <i class="mad-filter-icon"><img src="<?php echo e(asset('assets_front/yummi_svg_icons/carrot.svg')); ?>" alt="" class="svg"></i>
                                                                Vegetarian
                                                            </span>
                                                            <span>8</span>
                                                        </li>
                                                        <li class="color-2">
                                                            <span>
                                                                <i class="mad-filter-icon"><img src="<?php echo e(asset('assets_front/yummi_svg_icons/chili_pepper.svg')); ?>" alt="" class="svg"></i>
                                                                Spicy
                                                            </span>
                                                            <span>3</span>
                                                        </li>
                                                        <li>
                                                            <span>
                                                                <i class="mad-filter-icon type-2"><img src="<?php echo e(asset('assets_front/yummi_svg_icons/gluten_free.svg')); ?>" alt="" class="svg"></i>
                                                                Gluten Free
                                                            </span>
                                                            <span>5</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> -->
                        </div>
                        <!-- End of Product sorting -->

                        <!--================ Gallery ================-->
                        <div data-isotope-layout="grid" data-isotope-filter="#portfolio-filter" class="mad-products item-col-3 mad-grid--isotope" style="position: relative; height: 2508.69px;">
                            <div class="mad-grid-sizer"></div>

                            <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mad-grid-item mad-category-<?php echo e($list->category_id); ?>" style="height: 627.172px; position: absolute; left: 0%; top: 0px;">
                                <!-- Product -->
                                <div class="mad-product">
                                    <figure class="mad-product-image">
                                        <a href="#"><img src="<?php echo e(asset('storage/media/'.$list->image)); ?>" alt=""></a>
                                    </figure>
                                    <!-- product-desc -->
                                    <div class="mad-product-description">
                                        <h4 class="mad-product-title"><a href="#" class="mad-link"><?php echo e($list->name); ?></a></h4>
                                        <p><?php echo e($list->short_desc); ?></p>
                                    </div>
                                    <!--/ product-desc -->
                                    <div class="mad-product-calc">
                                        <span class="mad-product-price"><?php echo e($list->product_price); ?></span>
                                        <a href="<?php echo e(url('product')); ?>/<?php echo e($list->slug); ?>" class="btn btn-style-3 btn-small">Select Options</a>
                                    </div>
                                </div>
                                <!-- End of Product -->
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                        <!--================ End of Gallery ================-->
                        <!-- <ul class="mad-pagination justify-content-center">
                            <li><a href="#" class="prev mad-arrows"><img src="<?php echo e(asset('assets_front/yummi_svg_icons/arrow_left.svg')); ?>" alt="" class="svg"></a></li>
                            <li><a href="#" class="page-numbers">1</a></li>
                            <li><a href="#" class="page-numbers current">2</a></li>
                            <li><a href="#" class="page-numbers">3</a></li>
                            <li><a href="#" class="next mad-arrows"><img src="<?php echo e(asset('assets_front/yummi_svg_icons/arrow_right.svg')); ?>" alt="" class="svg"></a></li>
                        </ul> -->
                    </main>
                    <aside id="sidebar" class="mad-sidebar col-xl-3">
                        <div class="mad-widget">
                            <div class="shopping-cart">
                                <h5 class="mad-widget-title">Cart</h5>
                                <div class="mad-products mad-product-small">
                                    <div class="mad-col">
                                        <!-- Product -->
                                        <div class="mad-product">
                                            <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                                            <a href="#" class="mad-product-image">
                                                <img src="<?php echo e(asset('assets_front/images/72x72_img1.jpg')); ?>" alt="">
                                            </a>
                                            <!-- product-info -->
                                            <div class="mad-product-description">
                                                <h6 class="mad-product-title"><a href="#" class="mad-link">Chicken Burger</a></h6>
                                                <span class="mad-product-price">1 × $14.99</span>
                                            </div>
                                            <!--/ product-info -->
                                        </div>
                                        <!-- End of Product -->
                                    </div>
                                    <div class="mad-col">
                                        <!-- Product -->
                                        <div class="mad-product">
                                            <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                                            <a href="#" class="mad-product-image">
                                                <img src="<?php echo e(asset('assets_front/images/72x72_img2.jpg')); ?>" alt="">
                                            </a>
                                            <!-- product-info -->
                                            <div class="mad-product-description">
                                                <h6 class="mad-product-title"><a href="#" class="mad-link">Affogato</a></h6>
                                                <span class="mad-product-price">1 x $4.99</span>
                                            </div>
                                            <!--/ product-info -->
                                        </div>
                                        <!-- End of Product -->
                                    </div>
                                    <div class="mad-col">
                                        <!-- Product -->
                                        <div class="mad-product">
                                            <button class="mad-close-item"><i class="material-icons-outlined">cancel</i></button>
                                            <a href="#" class="mad-product-image">
                                                <img src="<?php echo e(asset('assets_front/images/72x72_img3.jpg')); ?>" alt="">
                                            </a>
                                            <!-- product-info -->
                                            <div class="mad-product-description">
                                                <h6 class="mad-product-title"><a href="#" class="mad-link">Conchiglia
                                                        Verdura.</a></h6>
                                                <span class="mad-product-price">1 x $14.99</span>
                                            </div>
                                            <!--/ product-info -->
                                        </div>
                                        <!-- End of Product -->
                                    </div>
                                </div>
                                <div class="sc-footer">
                                    <div class="subtotal">Subtotal: <span class="mad-price">34.97</span></div>
                                    <a href="#" class="btn btn-small btn-style-3 w-100"><i class="material-icons">arrow_right_alt</i><span>Checkout</span></a>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
        <!--================ Footer ================-->
        <footer id="mad-footer" class="mad-footer">
            <!--================ Footer row ================-->
            <div class="mad-footer-main">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-6 col-lg-4 col-md-6">
                            <!--================ Widget ================-->
                            <section class="mad-widget">
                                <div class="content-element-5">
                                    <a href="#" class="mad-logo"><img src="<?php echo e(asset('assets_front/images/dlogo.png')); ?>" style="width: 170px;" alt=""></a>
                                </div>
                                <div class="mad-our-info vr-type">
                                    <div class="mad-info"><i class="material-icons-outlined">location_on</i> <span>8901 Marmora Road, New York, NY 10013 <br> <a href="#" class="mad-link mad-dir">Get Directions</a></span></div>
                                    <div class="mad-info"><i class="material-icons-outlined">call</i> <span>+1 800 559 6580</span></div>
                                    <div class="mad-info"><i class="material-icons">mail_outline</i> <a href="#" class="mad-link">mail@companyname.com</a></div>
                                    <div class="mad-info"><i class="material-icons">access_time</i> <span>Mon - Fri: 8am - 11pm, Sat - Sun: 8am - 12pm</span></div>
                                </div>
                            </section>
                            <!--================ End of Widget ================-->
                        </div>
                        <div class="col-xl-2 col-lg-2 col-md-6">
                            <!--================ Widget ================-->
                            <section class="mad-widget">
                                <h5 class="mad-widget-title">Menu</h5>
                                <div class="mad-vr-list">
                                    <ul>
                                        <li><a href="#" class="mad-link">Pizza</a></li>
                                        <li><a href="#" class="mad-link">Pasta</a></li>
                                        <li><a href="#" class="mad-link">Burgers</a></li>
                                        <li><a href="#" class="mad-link">Sides</a></li>
                                        <li><a href="#" class="mad-link">Desserts</a></li>
                                        <li><a href="#" class="mad-link">Drinks</a></li>
                                    </ul>
                                </div>
                            </section>
                            <!--================ End of Widget ================-->
                        </div>
                        <div class="col-xl-2 col-lg-3 col-md-6">
                            <!--================ Widget ================-->
                            <section class="mad-widget">
                                <h5 class="mad-widget-title">Company</h5>
                                <div class="mad-vr-list">
                                    <ul>
                                        <li><a href="#" class="mad-link">About</a></li>
                                        <li><a href="#" class="mad-link">The Menu</a></li>
                                        <li><a href="#" class="mad-link">Testimonials</a></li>
                                        <li><a href="#" class="mad-link">Blog</a></li>
                                        <li><a href="#" class="mad-link">Shop</a></li>
                                        <li><a href="#" class="mad-link">Gift Cards</a></li>
                                    </ul>
                                </div>
                            </section>
                            <!--================ End of Widget ================-->
                        </div>
                        <div class="col-xl-2 col-lg-3 col-md-6">
                            <!--================ Widget ================-->
                            <section class="mad-widget">
                                <h5 class="mad-widget-title">Support</h5>
                                <div class="mad-vr-list">
                                    <ul>
                                        <li><a href="#" class="mad-link">How to Order</a></li>
                                        <li><a href="#" class="mad-link">Where We Deliver</a></li>
                                        <li><a href="#" class="mad-link">FAQs</a></li>
                                        <li><a href="#" class="mad-link">Contact</a></li>
                                        <li><a href="#" class="mad-link">Terms and Contiotions</a></li>
                                        <li><a href="#" class="mad-link">Privacy Policy</a></li>
                                    </ul>
                                </div>
                            </section>
                            <!--================ End of Widget ================-->
                        </div>
                    </div>
                </div>
            </div>
            <!--================ End of Footer row ================-->
            <div class="mad-footer-bottom">
                <div class="container">
                    <p class="copyrights">Copyright © 2021 Yummi.
                        All Rights Reserved.</p>
                    <div class="mad-social-icons">
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="#"><i class="fab fa-tripadvisor"></i></a></li>
                            <li><a href="#"><i class="fab fa-youtube"></i></a></li>
                            <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <!--================ End of Footer ================-->
    </div>
    <script src="<?php echo e(asset('assets_front/vendors/modernizr.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/jquery-3.3.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/jquery.easing.1.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/jquery.parallax-1.1.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/monkeysan.jquery.nav.1.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/monkeysan.validator.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/handlebars-v4.0.5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/mad.customselect.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/jquery-ui/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/arcticmodal/jquery.arcticmodal-0.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/vendors/retina.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/js/modules/mad.alert-box.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/js/modules/mad.newsletter-form.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/js/modules/mad.isotope.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/js/modules/mad.sticky-header-section.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets_front/js/mad.app.js')); ?>"></script>
</body>

</html><?php /**PATH D:\Xampp\htdocs\pizzafront\resources\views\front\shop.blade.php ENDPATH**/ ?>